/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.crd.impl;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.DeviceId;
import ru.softlogic.hdw.TaskBus;
import ru.softlogic.hdw.base.BaseDevice;
import ru.softlogic.hdw.dev.crd.CRMsg;
import ru.softlogic.hdw.dev.crd.CardReader;
import ru.softlogic.hdw.dev.crd.CardReaderDriver;
import ru.softlogic.hdw.dev.crd.CardReaderException;
import ru.softlogic.hdw.dev.crd.CardStateListener;
import ru.softlogic.hdw.dev.crd.CustomApi;
import ru.softlogic.hdw.dev.crd.IcApi;
import ru.softlogic.hdw.dev.crd.MagneticApi;
import ru.softlogic.hdw.handling.DeviceInfo;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.utils.SerialFmt;

public abstract class BaseCardReaderDriver
extends BaseDevice
implements CardReader,
CardReaderDriver,
Runnable {
    private final List<Thread> threads;
    private final SerialPort port;
    private final DeviceId deviceId;
    private final TaskBus bus;
    protected MagneticApi magneticApi;
    protected IcApi icApi;
    protected volatile int currCardState = 0;
    protected Logger log;
    protected CardStateListener cardStateListener;
    protected volatile boolean enabled;
    private boolean delayedDisable;

    public BaseCardReaderDriver(DeviceId deviceId, SerialPort port, String baseDrvVersion, Logger log) {
        super(deviceId, baseDrvVersion, log);
        this.deviceId = deviceId;
        this.port = port;
        this.log = log;
        this.threads = new LinkedList<Thread>();
        this.threads.add(new Thread((Runnable)this, "drv(" + deviceId.getType() + ")"));
        this.bus = new TaskBus(log);
        this.threads.add(new Thread((Runnable)this.bus, "DriverTaskBus"));
    }

    public BaseCardReaderDriver(DeviceId deviceId, String baseDrvVersion, Logger log) {
        super(deviceId, baseDrvVersion, log);
        this.deviceId = deviceId;
        this.port = null;
        this.log = log;
        this.threads = new LinkedList<Thread>();
        this.threads.add(new Thread((Runnable)this, "drv(" + deviceId.getType() + ")"));
        this.bus = new TaskBus(log);
        this.threads.add(new Thread((Runnable)this.bus, "DriverTaskBus"));
        this.enabled = false;
    }

    @Override
    public MagneticApi getMagneticApi() {
        if (this.currCardState != 2) {
            throw new IllegalStateException("The operation is not allowed in the  " + CRMsg.getCardState(this.currCardState));
        }
        return this.magneticApi;
    }

    @Override
    public int getCurrentCardState() {
        return this.currCardState;
    }

    @Override
    public void enableDevice(CardStateListener cardStateListener) {
        this.log.info((Object)"Device is enable");
        if (this.enabled) {
            throw new IllegalStateException("Device is already on");
        }
        this.cardStateListener = cardStateListener;
        this.enabled = true;
        this.notifyAboutCardState(this.currCardState);
    }

    @Override
    public void disableDevice() {
        if (!this.enabled) {
            throw new IllegalStateException("Device is already off");
        }
        this.enabled = false;
    }

    public static int getProtocolByATR(byte[] atr) {
        int count = 1;
        int hT0 = (atr[1] & 0xFF) >> 4;
        if ((hT0 & 8) != 0) {
            int i = 8;
            do {
                if ((hT0 & i) <= 0) continue;
                ++count;
            } while ((i >>= 1) > 0);
            return atr[count] & 0xF;
        }
        return 0;
    }

    @Override
    public synchronized void ejectCard() throws CardReaderException {
        if (this.currCardState != 2) {
            throw new IllegalStateException("The card can not be ejected from the " + CRMsg.getCardState(this.currCardState));
        }
        this.updateCardState(4);
    }

    @Override
    public CardReader getCardReader() {
        return this;
    }

    @Override
    public List<Thread> getThreads() {
        return this.threads;
    }

    @Override
    public void release() {
        this.log.info((Object)"Device release");
        this.enabled = false;
        this.cardStateListener = null;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public final void run() {
        this.log.info((Object)"Start cardreader driver");
        if (this.port != null) {
            this.log.info((Object)("Port: " + SerialFmt.format((SerialPort)this.port)));
        }
        this.log.info((Object)("Driver: " + this.deviceId.getType() + ", number: " + this.deviceId.getNumber()));
        try {
            this._run();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        if (this.port != null) {
            this.port.close();
        }
        this.log.info((Object)"Stop thread");
    }

    protected abstract void _run() throws InterruptedException;

    protected void addThread(Thread thread) {
        if (thread == null) {
            throw new NullPointerException("Thread is null");
        }
        this.threads.add(thread);
    }

    protected synchronized void updateCardState(int cardState) {
        if (this.currCardState == 4 && cardState == 1) {
            return;
        }
        if (this.currCardState == 4 && cardState == 0) {
            this.updateCardState(5);
            if (this.delayedDisable) {
                this.enabled = false;
                this.delayedDisable = false;
            }
            return;
        }
        if (this.currCardState != cardState) {
            this.log.info((Object)("CARD STATE IS CHANGE: " + CRMsg.getCardState(this.currCardState) + "->" + CRMsg.getCardState(cardState)));
            this.currCardState = cardState;
            this.notifyAboutCardState(this.currCardState);
            if (this.currCardState == 3 || this.currCardState == 5) {
                this.updateCardState(0);
            }
        }
    }

    protected void notifyAboutCardState(int state) {
        this.bus.addTask(new CardStateNotifier(state));
    }

    protected DeviceInfo createDeviceInfo() {
        DeviceInfo di = new DeviceInfo(this.deviceId.getDeviceClass(), this.deviceId.getType());
        if (this.port != null) {
            di.setPort(SerialFmt.format((SerialPort)this.port));
        }
        return di;
    }

    @Override
    public CustomApi getCustomApi() {
        return null;
    }

    private class CardStateNotifier
    implements Runnable {
        private final int state;

        public CardStateNotifier(int state) {
            this.state = state;
            BaseCardReaderDriver.this.log.info((Object)"Create notification task");
        }

        @Override
        public void run() {
            BaseCardReaderDriver.this.log.info((Object)"Execute notification task.");
            BaseCardReaderDriver.this.log.info((Object)("\tState: " + CRMsg.getCardState(this.state)));
            BaseCardReaderDriver.this.log.info((Object)("\tCardStateListener: " + BaseCardReaderDriver.this.cardStateListener != null ? 1 : 0));
            if (BaseCardReaderDriver.this.cardStateListener != null) {
                BaseCardReaderDriver.this.cardStateListener.onCardState(this.state);
            }
        }

        public String toString() {
            return "CardStateNotifier{state=" + this.state + '}';
        }
    }
}

