/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.crd;

import java.util.Arrays;

public class APDUResponse {
    public static final int EMV_NORMAL = 36864;
    public static final int EMV_SELECTED_FILE_INVALIDATED = 25219;
    public static final int EMV_NO_INFORMATION_GIVEN = 25344;
    public static final int EMV_RECORD_NOT_FOUND = 27267;
    private final byte[] data;
    private final byte sw1;
    private final byte sw2;
    private final int result;

    public APDUResponse(byte[] data, byte sw1, byte sw2) {
        this.data = data;
        this.sw1 = sw1;
        this.sw2 = sw2;
        this.result = ((sw1 & 0xFF) << 8) + (sw2 & 0xFF);
    }

    public APDUResponse(byte[] response) {
        this.sw1 = response[response.length - 2];
        this.sw2 = response[response.length - 1];
        byte[] responseDate = new byte[response.length - 2];
        System.arraycopy(response, 0, responseDate, 0, responseDate.length);
        this.data = responseDate;
        this.result = ((this.sw1 & 0xFF) << 8) + (this.sw2 & 0xFF);
    }

    public byte[] getData() {
        return this.data;
    }

    public byte getSW1() {
        return this.sw1;
    }

    public byte getSW2() {
        return this.sw2;
    }

    public short getSW() {
        return (short)(((this.sw1 & 0xFF) << 8) + (this.sw2 & 0xFF));
    }

    public int getResult() {
        return this.result;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        for (byte b : this.data) {
            str.append(String.format("0x%02x ", (b + 256) % 256));
        }
        return "ABDUResponse{date=" + str.toString() + ", sw1=" + String.format("0x%02x", (this.sw1 + 256) % 256) + ", sw2=" + String.format("0x%02x", (this.sw2 + 256) % 256) + ", dateToStr: " + new String(this.data) + '}';
    }

    public int hashCode() {
        int hash = 3;
        hash = 29 * hash + Arrays.hashCode(this.data);
        hash = 29 * hash + this.sw1;
        hash = 29 * hash + this.sw2;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        APDUResponse other = (APDUResponse)obj;
        if (!Arrays.equals(this.data, other.data)) {
            return false;
        }
        if (this.sw1 != other.sw1) {
            return false;
        }
        return this.sw2 == other.sw2;
    }
}

