/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.cashdisp.impl.v2;

import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.hardware.currency.SumFormatter;
import ru.softlogic.hdw.dev.cashdisp.impl.v2.BoxedCashDispenserDriver;
import ru.softlogic.storage.cash.Box;
import ru.softlogic.storage.cash.BoxVisitor;

abstract class ValidBoxVisitor
implements BoxVisitor {
    private final BoxedCashDispenserDriver drv;
    private final Logger log;

    public ValidBoxVisitor(BoxedCashDispenserDriver drv, Logger log) {
        this.drv = drv;
        this.log = log;
    }

    @Override
    public final void onBox(Box box) {
        if (box.getBoxInfo().getType() == 3) {
            this.log.info((Object)("Process box: " + box));
            Map<Denomination, Integer> counts = box.getCounts();
            this.log.info((Object)("    Counts: " + counts));
            if (counts.size() == 1) {
                if (this.drv.isBoxWorkingProperly(box.getId())) {
                    Map.Entry<Denomination, Integer> entry = counts.entrySet().iterator().next();
                    this.log.info((Object)("    Contains: " + SumFormatter.asStr(entry.getKey()) + ": " + entry.getValue()));
                    this.onValidBox(box, entry.getKey(), entry.getValue());
                } else {
                    this.log.info((Object)"    Faulty box, skip");
                }
            } else if (counts.size() > 1) {
                this.log.error((Object)"    Wrong box count. Only one nominal may be present");
            } else {
                this.log.info((Object)"    Empty box, skip");
            }
        }
    }

    protected abstract void onValidBox(Box var1, Denomination var2, int var3);
}

