/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.cashdisp.impl.v2;

import java.io.IOException;
import java.util.Arrays;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.hardware.currency.Dimensions;
import ru.softlogic.hardware.currency.set.DenominationSet;
import ru.softlogic.hdw.DeviceId;
import ru.softlogic.hdw.dev.cashdisp.CashDispenserDescriptor;
import ru.softlogic.hdw.dev.cashdisp.impl.v2.BoxedCashDispenserDriver;
import ru.softlogic.hdw.dev.cashdisp.impl.v2.DimensionVisitor;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.storage.cash.BaseBox;
import ru.softlogic.storage.cash.BaseStore;
import ru.softlogic.storage.cash.Box;
import ru.softlogic.storage.cash.BoxInfo;
import ru.softlogic.storage.cash.InternalStorage;
import ru.softlogic.storage.cash.Store;
import ru.softlogic.storage.cash.StoreUtils;
import ru.softlogic.storage.cash.Transfer;
import ru.softlogic.storage.io.Serializator;

public abstract class BoxedNoteDispenserDriver
extends BoxedCashDispenserDriver {
    private Store mainStore;
    private Box rejectBox;
    private Box jammBox;
    private InternalStorage storage;
    private Dimensions[] prev;
    private final Logger log;

    public BoxedNoteDispenserDriver(DeviceId deviceId, SerialPort port, Serializator serializator, Logger log) {
        super(deviceId, port, serializator, log);
        this.log = log;
        short dc = deviceId.getDeviceClass();
        if (dc != 16) {
            throw new IllegalArgumentException("Wrong device class " + dc);
        }
        this.createStores();
    }

    private void createStores() {
        DeviceId did = this.getDeviceId();
        CashDispenserDescriptor descriptor = this.getDescriptor();
        this.storage = this.createStorage();
        Box[] boxes = new Box[descriptor.getBoxCount() + 2];
        for (short i = 0; i < descriptor.getBoxCount(); i = (short)(i + 1)) {
            boxes[i] = new BaseBox(i, new BoxInfo(3, descriptor.getBoxCapacity(), 3), this.storage, new BoxedCashDispenserDriver.DispenserPhysicalBox(i));
        }
        BaseBox baseBox = new BaseBox((short)(boxes.length - 2), new BoxInfo(4, descriptor.getRejectBoxCapacity(), 13), this.storage);
        boxes[boxes.length - 2] = baseBox;
        this.rejectBox = baseBox;
        BaseBox baseBox2 = new BaseBox((short)(boxes.length - 1), new BoxInfo(5, 10, 1), this.storage);
        boxes[boxes.length - 1] = baseBox2;
        this.jammBox = baseBox2;
        this.mainStore = new BaseStore("CashDispenser." + did.getNumber(), boxes, this.storage);
    }

    @Override
    public final Store getStore() {
        return this.mainStore;
    }

    @Override
    protected final InternalStorage getStorage() {
        return this.storage;
    }

    @Override
    protected final Transfer processReject(short boxId, Denomination denomination, int rejectCount) {
        int max = this.storage.getCount(boxId, denomination);
        this.log.info((Object)("Make transfer to reject, exist: " + max + ", requested: " + rejectCount));
        if (max < rejectCount) {
            this.notifyProblem("Wrong counts on transfer to REJECT, exist: " + max + ", requested: " + rejectCount);
        }
        return new Transfer(boxId, this.rejectBox.getId(), new DenominationSet(denomination, Math.min(rejectCount, max)));
    }

    @Override
    protected final Transfer processJamm(short boxId, Denomination denomination, int jammCount) {
        int max = this.storage.getCount(boxId, denomination);
        this.log.info((Object)("Make transfer to jamm, exist: " + max + ", requested: " + jammCount));
        if (max < jammCount) {
            this.notifyProblem("Wrong counts on transfer to JAMM, exist: " + max + ", requested: " + jammCount);
        }
        return new Transfer(boxId, this.jammBox.getId(), new DenominationSet(denomination, Math.min(jammCount, max)));
    }

    @Override
    protected final void beforeDispence() throws IOException {
        DimensionVisitor dv = new DimensionVisitor(this, this.log);
        StoreUtils.walk(this.mainStore, dv);
        Object[] dims = new Dimensions[this.getDescriptor().getBoxCount()];
        for (short i = 0; i < dims.length; i = (short)(i + 1)) {
            Dimensions ds = dv.getResult().get(i);
            dims[i] = ds != null ? ds : Dimensions.DEFAULT;
        }
        if (!Arrays.equals(dims, this.prev)) {
            this.log.info((Object)("Update note dimensions: " + Arrays.toString(dims)));
            this.updateDimensions((Dimensions[])dims);
            this.prev = dims;
        }
    }

    protected void updateDimensions(Dimensions[] dims) throws IOException {
    }
}

