/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.cashdisp.impl.v2;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.hardware.currency.set.DenominationSet;
import ru.softlogic.hdw.DeviceId;
import ru.softlogic.hdw.dev.cashdisp.BoxState;
import ru.softlogic.hdw.dev.cashdisp.EmptyChannel;
import ru.softlogic.hdw.dev.cashdisp.OperationDispenseResult;
import ru.softlogic.hdw.dev.cashdisp.PayoutBySetOperation;
import ru.softlogic.hdw.dev.cashdisp.PayoutException;
import ru.softlogic.hdw.dev.cashdisp.boxed.BoxDispense;
import ru.softlogic.hdw.dev.cashdisp.boxed.BoxedOperation;
import ru.softlogic.hdw.dev.cashdisp.impl.v2.BaseCashDispenserDriver;
import ru.softlogic.hdw.dev.cashdisp.impl.v2.CountsVisitor;
import ru.softlogic.hdw.dev.cashdisp.impl.v2.Dispense;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.utils.SerialFmt;
import ru.softlogic.storage.cash.BoxId;
import ru.softlogic.storage.cash.InternalStorage;
import ru.softlogic.storage.cash.SimplePhysicalBox;
import ru.softlogic.storage.cash.StoreUtils;
import ru.softlogic.storage.cash.Transfer;
import ru.softlogic.storage.io.Serializator;

public abstract class BoxedCashDispenserDriver
extends BaseCashDispenserDriver {
    private final SerialPort port;
    private final BlockingQueue<BoxedOperation> operations;
    private final Logger log;

    public BoxedCashDispenserDriver(DeviceId deviceId, SerialPort port, Serializator serializator, Logger log) {
        super(deviceId, port, serializator, log);
        short dc = deviceId.getDeviceClass();
        if (dc != 16 && dc != 18) {
            throw new IllegalArgumentException("Allowable classes 16 18");
        }
        this.port = port;
        this.log = log;
        this.operations = new LinkedBlockingDeque<BoxedOperation>();
    }

    @Override
    public void payout(PayoutBySetOperation payout) throws PayoutException {
        if (payout == null) {
            throw new NullPointerException("PayoutBySetOperation is null");
        }
        this.checkAlive();
        this.checkDispensingSet(payout.getCounts());
        this.log.info((Object)"========================================================");
        this.log.info((Object)("Begin payout by set, requested counts: " + payout.getCounts()));
        String[] currencies = payout.getCounts().getCurrencies();
        this.operations.add(new BoxedOperation(2, payout.getCounts().getCounts(), currencies[0], payout.getListener()));
    }

    private void checkDispensingSet(DenominationSet dispensingSet) throws PayoutException {
        if (dispensingSet == null) {
            throw new NullPointerException("Dispensing set is null");
        }
        if (dispensingSet.getTotalCount() > this.getDescriptor().getTotalDispenseCount()) {
            throw new PayoutException("Maximum number bills/coins for dispensing has been exceeded");
        }
    }

    @Override
    public void run() {
        this.log.info((Object)"Start thread");
        this.log.info((Object)("Device type: " + Thread.currentThread().getName()));
        this.log.info((Object)("Serial: " + SerialFmt.format((SerialPort)this.port)));
        this.printDispenserInfo();
        block5: while (true) {
            try {
                while (!Thread.currentThread().isInterrupted()) {
                    BoxedOperation op = null;
                    try {
                        op = this.operations.poll(500L, TimeUnit.MILLISECONDS);
                        this.checkConnection();
                        if (op != null) {
                            this.log.info((Object)"Process payout operation");
                            CountsVisitor cv = new CountsVisitor(op.getCounts(), this.getDescriptor().getTotalDispenseCount(), this, this.log);
                            StoreUtils.walk(this.getStore(), cv);
                            Map<Short, Dispense> reqDispense = cv.getCounts();
                            if (reqDispense.isEmpty()) {
                                this.notifyProblem("Empty payout");
                                op.getListener().onPrepareError();
                                continue;
                            }
                            this.beforeDispence();
                            int[] disp = new int[this.getDescriptor().getBoxCount()];
                            for (short i = 0; i < disp.length && i < Short.MAX_VALUE; i = (short)(i + 1)) {
                                disp[i] = reqDispense.get(i) != null ? reqDispense.get(i).getCount() : 0;
                            }
                            this.log.info((Object)"Start dispense...");
                            BoxDispense[] res = this.makeDispense(disp);
                            TreeMap<BoxId, DenominationSet> result = new TreeMap<BoxId, DenominationSet>();
                            this.log.info((Object)"Result: ");
                            LinkedList<Transfer> transfers = new LinkedList<Transfer>();
                            for (short i = 0; i < res.length && i < Short.MAX_VALUE; i = (short)(i + 1)) {
                                BoxDispense bd = res[i];
                                this.log.info((Object)("    " + i + " required=" + disp[i] + "->" + bd));
                                Dispense d = reqDispense.get(i);
                                if (d == null) continue;
                                if (disp[i] < bd.getLeaveCount()) {
                                    this.notifyProblem("Error on dispencing, box:" + i + " requested:" + disp[i] + ", result:" + bd);
                                }
                                if (bd.getGiveCount() > 0) {
                                    this.log.info((Object)("Remove give counts, box: " + i + ", den=" + d.getDenomination() + ", " + bd.getGiveCount()));
                                    this.getStorage().remove(i, d.getDenomination(), bd.getGiveCount());
                                    if (bd.getGiveCount() > 0) {
                                        result.put(new BoxId(this.getDeviceId().getDeviceClass(), this.getDeviceId().getNumber(), i), new DenominationSet(d.getDenomination(), bd.getGiveCount()));
                                    }
                                }
                                if (bd.getRejectCount() > 0) {
                                    transfers.add(this.processReject(i, d.getDenomination(), bd.getRejectCount()));
                                }
                                if (bd.getJammCount() <= 0) continue;
                                transfers.add(this.processJamm(i, d.getDenomination(), bd.getJammCount()));
                            }
                            op.getListener().onResult(new OperationDispenseResult(result));
                            this.getStorage().transfer(transfers);
                        } else {
                            this.checkState();
                        }
                        this.onConnSuccess();
                        continue block5;
                    }
                    catch (IOException ex) {
                        if (op != null) {
                            this.log.info((Object)"Error, notify operation");
                            op.getListener().onError();
                        }
                        this.processConnectionError();
                        this.onConnError(ex);
                        this.randomSleep(500, 500);
                    }
                    catch (IllegalStateException ex) {
                        if (op == null) continue;
                        op.getListener().onError();
                    }
                }
                break;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        this.log.info((Object)"Stop thread");
    }

    private void checkAlive() throws PayoutException {
        if (!Thread.currentThread().isAlive()) {
            throw new PayoutException("Driver is malfunction, thread must be run");
        }
        if (!this.isOperable()) {
            throw new PayoutException("Driver is malfunction, wrong state: " + this.getLastState());
        }
    }

    protected abstract InternalStorage getStorage();

    protected abstract Transfer processReject(short var1, Denomination var2, int var3);

    protected abstract Transfer processJamm(short var1, Denomination var2, int var3);

    protected abstract boolean isBoxWorkingProperly(int var1);

    protected abstract void checkConnection() throws IOException;

    protected abstract void beforeDispence() throws IOException;

    protected abstract BoxDispense[] makeDispense(int[] var1) throws IOException, InterruptedException;

    protected abstract void processConnectionError();

    protected abstract void checkState() throws IOException;

    class DispenserPhysicalBox
    extends SimplePhysicalBox {
        public final int boxId;

        public DispenserPhysicalBox(int boxId) {
            this.boxId = boxId;
        }

        @Override
        public BoxState getState() {
            return BoxedCashDispenserDriver.this.getBoxState().get(this.boxId);
        }

        @Override
        public List<EmptyChannel> getEmptyChannels() {
            return BoxedCashDispenserDriver.this.getEmptyChannels();
        }
    }
}

