/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.cashacc;

import java.util.HashMap;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.hdw.BaseFactory;
import ru.softlogic.hdw.CreatingException;
import ru.softlogic.hdw.dev.cashacc.BvrOptions;
import ru.softlogic.hdw.dev.cashacc.CashAcceptorDescriptor;
import ru.softlogic.hdw.dev.cashacc.CashAcceptorDriver;
import ru.softlogic.hdw.dev.cashacc.PayoutProfile;
import ru.softlogic.io.Port;
import ru.softlogic.io.serial.SerialPort;

public class CashAcceptorFactory
extends BaseFactory {
    public static final String CCNET = "ccnet";
    public static final String EBDS = "ebds";
    public static final String ID003 = "id003";
    public static final String CCTALK = "cctalk";
    public static final String ITL = "itl";
    public static final String SSP = "ssp";
    public static final String SMARTPAYOUT = "smpt";

    private CashAcceptorFactory() {
    }

    public static CashAcceptorDriver createBillDriver(String type, SerialPort port, BvrOptions options, String currency, Logger log) throws CreatingException {
        CashAcceptorFactory.check(type, (Port)port);
        if (options == null) {
            throw new CreatingException("BvrOptions is not set");
        }
        String pkg = "ru.softlogic.hardware.bvr." + type.toLowerCase() + ".driver.Driver";
        try {
            Class<?> cl = Class.forName(pkg);
            return (CashAcceptorDriver)cl.getConstructor(String.class, SerialPort.class, BvrOptions.class, String.class, Logger.class).newInstance(type, port, options, currency, log);
        }
        catch (ClassNotFoundException ex) {
            throw new CreatingException(ex);
        }
        catch (Throwable ex) {
            throw new CreatingException(ex);
        }
    }

    public static CashAcceptorDescriptor createBillAcceptorDescriptor(String type) throws CreatingException {
        CashAcceptorFactory.checkType(type);
        return new CashAcceptorDescriptor(CashAcceptorFactory.getFeaturesQuetly("bvr", type));
    }

    public static PayoutProfile getProfileStub() {
        return new PayoutProfile("stub", "stub", new HashMap<Denomination, Integer>());
    }

    public static CashAcceptorDriver createCoinDriver(String type, SerialPort port, String currency, Logger log) throws CreatingException {
        CashAcceptorFactory.check(type, (Port)port);
        String pkg = "ru.softlogic.hardware.cvr." + type.toLowerCase() + ".driver.Driver";
        try {
            Class<?> cl = Class.forName(pkg);
            return (CashAcceptorDriver)cl.getConstructor(String.class, SerialPort.class, String.class, Logger.class).newInstance(type, port, currency, log);
        }
        catch (ClassNotFoundException ex) {
            throw new CreatingException(ex);
        }
        catch (Throwable ex) {
            throw new CreatingException(ex);
        }
    }
}

