/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.cashacc;

import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.softlogic.config.ParceException;
import ru.softlogic.config.SerialDeviceSection;
import ru.softlogic.hdw.dev.cashacc.BvrConfiguration;
import ru.softlogic.hdw.dev.cashacc.BvrOptions;
import ru.softlogic.io.serial.SerialPort;

public class BvrSection
extends SerialDeviceSection {
    public static final String USE_COIN = "use-coin";
    public static final String PAYOUT_PROFILE = "payout-profile";
    private BvrConfiguration bac;

    public BvrSection() {
    }

    public BvrSection(BvrConfiguration bac) {
        this.bac = bac;
    }

    @Override
    public String getKey() {
        return "bill-acc";
    }

    @Override
    public void parce(Element element) throws ParceException {
        boolean enable = this.getEnable(element);
        String type = this.getDriver(element);
        SerialPort port = this.getSerialPort(element);
        Map<String, String> opt = this.readOptions(element);
        boolean useCoin = this.readBoolean(opt, USE_COIN, false);
        String profile = this.readString(opt, PAYOUT_PROFILE, "");
        this.bac = new BvrConfiguration(enable, type, port, new BvrOptions(useCoin, profile));
    }

    @Override
    public Element generate(Document doc) {
        return this.generate(doc, this.bac);
    }

    @Override
    public void generateOptions(Document doc, Element root) {
        BvrOptions bo = this.bac.getOptions();
        if (bo != null) {
            if (bo.isCoinAccConnected()) {
                this.writeOption(doc, root, USE_COIN, Boolean.toString(bo.isCoinAccConnected()));
            }
            if (bo.getPayoutProfile() != null && !bo.getPayoutProfile().isEmpty()) {
                this.writeOption(doc, root, PAYOUT_PROFILE, bo.getPayoutProfile());
            }
        }
    }

    public BvrConfiguration getConfiguration() {
        return this.bac;
    }
}

