/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.barcode;

import org.apache.log4j.Logger;
import ru.softlogic.hdw.BaseFactory;
import ru.softlogic.hdw.CreatingException;
import ru.softlogic.hdw.dev.barcode.BarOptions;
import ru.softlogic.hdw.dev.barcode.BarcodeScannerDriver;
import ru.softlogic.hdw.dev.barcode.Descriptor;
import ru.softlogic.io.serial.SerialPort;

public class BarcodeFactory
extends BaseFactory {
    private BarcodeFactory() {
    }

    public static BarcodeScannerDriver createDriver(String type, SerialPort port, Logger log) throws CreatingException {
        BarcodeFactory.checkType(type);
        String pkg = "ru.softlogic.hardware.bar." + type.toLowerCase() + ".driver.Driver";
        try {
            Class<?> cl = Class.forName(pkg);
            BarcodeScannerDriver cr = (BarcodeScannerDriver)cl.getConstructor(String.class, SerialPort.class, BarOptions.class, Logger.class).newInstance(type, port, new BarOptions(), log);
            return cr;
        }
        catch (ClassNotFoundException ex) {
            throw new CreatingException(ex);
        }
        catch (Throwable ex) {
            throw new CreatingException(ex);
        }
    }

    public static Descriptor createDescriptor(String type) throws CreatingException {
        return new Descriptor(BarcodeFactory.getFeaturesQuetly("bar", type.toLowerCase()));
    }
}

