/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.charset;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.io.IOUtils;
import ru.softlogic.hdw.charset.Mapping;

class Loader {
    private static final Map<String, Mapping> CACHE = new HashMap<String, Mapping>();

    private Loader() {
    }

    public static synchronized Mapping getMapping(String encoding) {
        Mapping m = CACHE.get(encoding);
        if (m != null) {
            return m;
        }
        m = Loader.loadMapping(encoding);
        CACHE.put(encoding, m);
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Mapping loadMapping(String encoding) {
        TreeMap<Character, Byte> direct = new TreeMap<Character, Byte>();
        TreeMap<Byte, Character> reverse = new TreeMap<Byte, Character>();
        Properties prop = new Properties();
        InputStream io = Loader.class.getResourceAsStream("res/" + encoding + ".map");
        if (io != null) {
            try {
                prop.load(io);
                for (String key : prop.stringPropertyNames()) {
                    if (!key.matches("[0-9a-fA-F]{2}")) continue;
                    byte bt = (byte)Integer.parseInt(key, 16);
                    String val = prop.getProperty(key);
                    char ch = val.charAt(0);
                    reverse.put(bt, Character.valueOf(ch));
                    direct.put(Character.valueOf(ch), prop.containsKey(val) ? (byte)Integer.parseInt(prop.getProperty(val), 16) : bt);
                }
            }
            catch (IOException iOException) {
            }
            finally {
                IOUtils.closeQuietly((InputStream)io);
            }
        }
        return new Mapping(direct, reverse);
    }
}

