/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.base;

class ConnStat {
    private final long from = System.currentTimeMillis();
    private int errorCount;
    private int successCount;

    ConnStat() {
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public int getSuccessCount() {
        return this.successCount;
    }

    public void addFact(boolean error) {
        if (error) {
            ++this.errorCount;
        } else {
            ++this.successCount;
        }
    }

    public boolean isTresholdReached(int treshold) {
        if (treshold <= 1 || treshold >= 100) {
            throw new IllegalArgumentException("Treshold must be in range 1..99%");
        }
        int total = this.errorCount + this.successCount;
        if (total < 10 || this.successCount == 0) {
            return false;
        }
        double k = (double)this.errorCount * 100.0 / (double)(this.errorCount + this.successCount);
        return k >= (double)treshold;
    }

    public boolean isCollectedFor(int minutes) {
        if (minutes < 1 || minutes > 1440) {
            throw new IllegalArgumentException("Minutes must be in range 1..1440");
        }
        long curr = System.currentTimeMillis();
        return curr < this.from || (curr - this.from) / 1000L / 60L >= (long)minutes;
    }

    public String toString() {
        return "ConnStat{from=" + this.from + ", errorCount=" + this.errorCount + ", successCount=" + this.successCount + '}';
    }
}

