/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.base;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.DeviceId;
import ru.softlogic.hdw.Hardware;
import ru.softlogic.hdw.base.ConnStat;
import ru.softlogic.hdw.base.Device;
import ru.softlogic.hdw.base.UpdateApi;
import ru.softlogic.hdw.dev.sensors.Sensor;
import ru.softlogic.hdw.handling.DeviceInfo;
import ru.softlogic.hdw.handling.DeviceInfoListener;
import ru.softlogic.hdw.handling.DeviceProblemListener;
import ru.softlogic.hdw.handling.DeviceState;
import ru.softlogic.hdw.handling.DeviceStateListener;
import ru.softlogic.hdw.handling.HdwMsg;
import ru.softlogic.io.PortNotExistException;

public abstract class BaseDevice
implements Device {
    private DeviceId deviceId;
    private String baseDrvVersion;
    private Logger log;
    private Set<DeviceStateListener> stateListeners;
    private DeviceState state;
    private Set<DeviceInfoListener> infoListeners;
    private DeviceInfo deviceInfo;
    private Set<DeviceProblemListener> problemListeners;
    private int ioErrorCount;
    private final Object sleepSync = new Object();
    private boolean sleepFlag;
    private final Random rnd = new Random();
    private final Set<Integer> uniques = new HashSet<Integer>();
    private ConnStat connStat;
    private boolean unstableConn;

    public BaseDevice(DeviceId deviceId, String baseDrvVersion, Logger log) {
        if (deviceId == null) {
            throw new NullPointerException("DeviceId is null");
        }
        if (baseDrvVersion == null) {
            throw new NullPointerException("Base driver version is null");
        }
        if (log == null) {
            throw new NullPointerException("Logger is null");
        }
        this.deviceId = deviceId;
        this.baseDrvVersion = baseDrvVersion;
        this.log = log;
        this.infoListeners = new HashSet<DeviceInfoListener>();
        this.stateListeners = new HashSet<DeviceStateListener>();
        this.problemListeners = new HashSet<DeviceProblemListener>();
        this.state = new DeviceState(deviceId.getDeviceClass(), -6);
        this.connStat = new ConnStat();
    }

    @Override
    public final DeviceState getLastState() {
        return this.state;
    }

    @Override
    public boolean isOperable() {
        DeviceState ds = this.getLastState();
        return ds != null ? ds.isOk() : false;
    }

    @Override
    public final void addStateListener(DeviceStateListener deviceStateListener) {
        if (deviceStateListener == null) {
            throw new NullPointerException("Listener is null");
        }
        this.stateListeners.add(deviceStateListener);
    }

    @Override
    public final void removeStateListener(DeviceStateListener deviceStateListener) {
        if (deviceStateListener == null) {
            throw new NullPointerException("Listener is null");
        }
        this.stateListeners.remove(deviceStateListener);
    }

    @Override
    public final DeviceInfo getLastInfo() {
        return this.deviceInfo;
    }

    @Override
    public final void addDeviceProblemListener(DeviceProblemListener problemListener) {
        if (problemListener == null) {
            throw new NullPointerException("Listener is null");
        }
        this.problemListeners.add(problemListener);
    }

    @Override
    public final void removeDeviceProblemListener(DeviceProblemListener problemListener) {
        if (problemListener == null) {
            throw new NullPointerException("Listener is null");
        }
        this.problemListeners.remove(problemListener);
    }

    @Override
    public final void addDeviceInfoListener(DeviceInfoListener deviceInfoListener) {
        if (deviceInfoListener == null) {
            throw new NullPointerException("Listener is null");
        }
        this.infoListeners.add(deviceInfoListener);
    }

    @Override
    public final void removeDeviceInfoListener(DeviceInfoListener deviceInfoListener) {
        if (deviceInfoListener == null) {
            throw new NullPointerException("Listener is null");
        }
        this.infoListeners.remove(deviceInfoListener);
    }

    protected final void updateDeviceInfo(DeviceInfo deviceInfo) {
        if (!this.baseDrvVersion.isEmpty()) {
            deviceInfo.setDriver(this.baseDrvVersion + "/" + deviceInfo.getDriver());
        }
        if (this.deviceInfo == null || !this.deviceInfo.equals(deviceInfo)) {
            this.log.info((Object)("Update device info: " + deviceInfo));
            this.deviceInfo = deviceInfo;
            for (DeviceInfoListener dil : this.infoListeners) {
                dil.onDeviceInfo(deviceInfo);
            }
        }
    }

    protected final void updateState(int state) {
        this.updateState(new DeviceState(this.deviceId.getDeviceClass(), state, this.enrichFlags(0)));
    }

    protected final void updateState(int state, int flags) {
        this.updateState(new DeviceState(this.deviceId.getDeviceClass(), state, this.enrichFlags(flags)));
    }

    protected final void updateState(DeviceState state) {
        if (state == null) {
            throw new IllegalArgumentException("DeviceState can't be null");
        }
        if (!this.state.equals(state)) {
            this.log.info((Object)("Update state: " + this.state + "(" + HdwMsg.getState(this.state) + ")"));
            this.log.info((Object)("          --> " + state + "(" + HdwMsg.getState(state) + ")"));
            this.state = state;
            for (DeviceStateListener dsl : this.stateListeners) {
                dsl.onState(state);
            }
        }
    }

    private void processConnectionState(boolean error) {
        this.connStat.addFact(error);
        if (this.connStat.isCollectedFor(10)) {
            this.unstableConn = this.connStat.isTresholdReached(5);
            this.log.info((Object)("Connection stat: " + this.connStat + ", unstable=" + this.unstableConn));
            this.updateState(this.state.getState(), this.state.getFlags());
            this.connStat = new ConnStat();
        }
    }

    private int enrichFlags(int flags) {
        return this.unstableConn ? flags | Integer.MIN_VALUE : flags & Integer.MAX_VALUE;
    }

    protected final void onConnSuccess() {
        this.ioErrorCount = 0;
        this.processConnectionState(false);
    }

    protected final void onConnError(Exception ex) {
        this.processConnectionState(true);
        if (Hardware.ioDebugEnable()) {
            this.log.error((Object)"Error on i/o: ", (Throwable)ex);
        } else {
            this.log.error((Object)("Error on i/o: " + ex.getMessage()));
        }
        if (this.ioErrorCount < 5) {
            ++this.ioErrorCount;
            if (this.ioErrorCount == 5) {
                this.updateState(new DeviceState(this.deviceId.getDeviceClass(), -2));
            }
        }
    }

    protected final void onConnErrorWithSleep(IOException ex) throws InterruptedException {
        this.onConnError(ex);
        if (ex instanceof PortNotExistException) {
            this.sleep(5000);
        } else {
            this.randomSleep(500, 500);
        }
    }

    protected final void sleep(int timeout) throws InterruptedException {
        this.checkTimeout(timeout, "Timeout");
        this.makeSleep(timeout);
    }

    protected final void randomSleep(int maxTimeout) throws InterruptedException {
        this.checkTimeout(maxTimeout, "MaxTimeout");
        this.makeSleep(this.rnd.nextInt(maxTimeout));
    }

    protected final void randomSleep(int constTimeout, int randomTimeout) throws InterruptedException {
        this.checkTimeout(constTimeout, "ConstTimeout");
        this.checkTimeout(randomTimeout, "RandomTimeout");
        this.makeSleep(this.rnd.nextInt(constTimeout + randomTimeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeSleep(int timeout) throws InterruptedException {
        Object object = this.sleepSync;
        synchronized (object) {
            if (!this.sleepFlag) {
                this.sleepSync.wait(timeout);
            } else {
                this.sleepFlag = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void notifySleep() {
        Object object = this.sleepSync;
        synchronized (object) {
            this.sleepFlag = true;
            this.sleepSync.notifyAll();
        }
    }

    private void checkTimeout(int timeout, String name) {
        if (timeout <= 0) {
            throw new IllegalArgumentException(name + " must be positive");
        }
    }

    protected final void notifyProblem(String msg) {
        String nMsg = msg == null || msg.isEmpty() ? "Unknown" : msg;
        this.log.error((Object)("Notify problem: " + nMsg));
        for (DeviceProblemListener dpl : this.problemListeners) {
            dpl.onProblem(this.deviceId, nMsg);
        }
    }

    protected final void notifyProblemOnce(String msg) {
        String nMsg;
        String string = nMsg = msg == null || msg.isEmpty() ? "Unknown" : msg;
        if (!this.uniques.contains(nMsg.hashCode())) {
            this.uniques.add(nMsg.hashCode());
            this.log.error((Object)("Notify problem once: " + nMsg));
            for (DeviceProblemListener dpl : this.problemListeners) {
                dpl.onProblem(this.deviceId, nMsg);
            }
        }
    }

    protected final void notifySensorEvent(int sensorType, int sensorId, int value) {
        if (this.getSensors() == null) {
            return;
        }
        for (Sensor s : this.getSensors()) {
            if (s.getType() != sensorType || s.getId() != sensorId) continue;
            s.notifyListeners(value);
        }
    }

    @Override
    public DeviceId getDeviceId() {
        return this.deviceId;
    }

    @Override
    public UpdateApi getUpdateApi() {
        return null;
    }

    public ArrayList<Sensor> getSensors() {
        return null;
    }
}

