/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.app;

import java.util.Set;
import ru.softlogic.hardware.lookup.DeviceDescription;
import ru.softlogic.hardware.lookup.HardwareLookup;
import ru.softlogic.hardware.search.ConnectedDevice;
import ru.softlogic.hardware.search.DeviceSearcher;
import ru.softlogic.hardware.search.SearchListener;
import ru.softlogic.hardware.search.SearchResult;
import ru.softlogic.hardware.search.UsbConnectedDevice;
import ru.softlogic.hardware.search.VoidSearchFilter;
import ru.softlogic.hdw.CreatingException;
import ru.softlogic.io.PortScanner;
import ru.softlogic.io.serial.SerialParams;

public class Search {
    public static void main(String[] args) throws CreatingException {
        Set<DeviceDescription> dds = HardwareLookup.lookup();
        for (DeviceDescription dd : dds) {
            System.out.println(dd);
        }
        DeviceSearcher ms = new DeviceSearcher(10, 5, true);
        SearchResult sr = ms.search(PortScanner.scanSerial(), dds, null, new VoidSearchFilter(), new LocalSearchListener());
        System.out.println(">>==================");
        for (ConnectedDevice cd : sr.getDevices()) {
            System.out.println(cd);
        }
        System.out.println("<<==================");
        System.out.println(sr.getTimeout());
        ms.shutdown();
    }

    private static class LocalSearchListener
    implements SearchListener {
        private LocalSearchListener() {
        }

        @Override
        public void onBegin(String port) {
            System.out.println(">>>>beg>>>>" + port);
        }

        public void onProgress(String port, DeviceDescription dd, SerialParams params) {
            System.out.println(">>>>pro>>>>" + port + ", " + dd.getType() + ", " + params);
        }

        @Override
        public void onResult(String port, ConnectedDevice cd) {
            System.out.println(">>>>res>>>>" + port + ", " + cd);
        }

        @Override
        public void onProgress(String port, DeviceDescription dd, String params) {
        }

        @Override
        public void onResult(String port, UsbConnectedDevice cd) {
        }
    }
}

