/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;

public class TaskBus
implements Runnable {
    private final BlockingQueue<Runnable> tasks;
    private final Logger log;

    public TaskBus(Logger log) {
        if (log == null) {
            throw new NullPointerException("Logger is not set");
        }
        this.log = log;
        this.tasks = new LinkedBlockingQueue<Runnable>();
    }

    public void addTask(Runnable run) {
        this.tasks.add(run);
    }

    @Override
    public void run() {
        block4: while (true) {
            try {
                while (!Thread.currentThread().isInterrupted()) {
                    Runnable run = this.tasks.take();
                    try {
                        run.run();
                        continue block4;
                    }
                    catch (Throwable ex) {
                        this.log.error((Object)("Error on task: " + run), ex);
                    }
                }
                break;
            }
            catch (InterruptedException ex) {
                this.log.error((Object)"Tus bus was interrupt");
                Thread.currentThread().interrupt();
                break;
            }
        }
    }
}

