/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw;

import org.apache.log4j.Logger;

public class StateMatcher<T> {
    public static final int INTERVAL_ON_CHANGE = -1;
    public static final int INTERVAL_1H = 60;
    public static final int INTERVAL_3H = 180;
    public static final int INTERVAL_6H = 360;
    public static final int INTERVAL_12H = 720;
    private T last;
    private long lastChange;
    private final Logger log;
    private final int interval;

    public StateMatcher(Logger log) {
        this(log, -1);
    }

    public StateMatcher(Logger log, int interval) {
        this.log = log;
        this.interval = interval;
    }

    public boolean isChange(T obj) {
        long now = System.currentTimeMillis();
        if (this.last == null || !this.last.equals(obj)) {
            if (this.interval <= 0) {
                this.log.info((Object)("State change: " + obj));
            }
            this.last = obj;
            this.lastChange = now;
            return true;
        }
        if (this.interval > 0 && now - this.lastChange > 3600000L * (long)this.interval) {
            this.log.info((Object)("State current: " + obj));
        }
        return false;
    }
}

