/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.BundleHolder;
import ru.softlogic.hdw.CodeException;

public class Result<T> {
    public static final int OK = 0;
    public static final int WRONG_ANS = -1;
    public static final int CONVERSION_ERROR = -2;
    private static final String KEYS_FORMAT = "keys.format";
    private static final Map<String, BundleHolder> BUNDLES = new HashMap<String, BundleHolder>();
    private final String function;
    private final int error;
    private T data;
    private final String message;

    public Result(Class context, int error) {
        this(context, "n/a", error, null);
    }

    public Result(Class context, String function, int error) {
        this(context, function, error, null);
    }

    public Result(Class context, String function, T data) {
        this(context, function, 0, data);
    }

    public Result(Class context, String function, int error, T data) {
        this.function = function;
        this.error = error;
        this.data = data;
        this.message = Result.getMessage(context, error);
    }

    public String getFunction() {
        return this.function;
    }

    public int getError() {
        return this.error;
    }

    public T getData() {
        return this.data;
    }

    public boolean isOk() {
        return this.error == 0;
    }

    public Result<T> check() throws CodeException {
        if (this.error != 0) {
            throw new CodeException(this.error, this.function + ": " + this.message);
        }
        return this;
    }

    public T take() throws CodeException {
        if (this.error != 0) {
            throw new CodeException(this.error, this.function + ": " + this.message);
        }
        return this.getData();
    }

    public Result<T> log(Logger log) {
        log.info((Object)(this.function + ", res=" + this.error + "(" + this.message + ")" + (this.data != null ? ", data=" + this.data : "")));
        return this;
    }

    public static String getMessage(Class context, int error) {
        BundleHolder bh = Result.getBundleHolder(context, ".errors");
        String key = String.format(bh.getFormat(), error);
        try {
            return bh.getBundle().getString(key);
        }
        catch (Throwable ex) {
            return key;
        }
    }

    public String toString() {
        return "Result{error=" + this.error + ", data=" + this.data + '}';
    }

    private static synchronized BundleHolder getBundleHolder(Class context, String name) {
        if (context == null) {
            throw new NullPointerException("Context is null");
        }
        String pkg = context.getPackage().getName();
        BundleHolder rb = BUNDLES.get(pkg);
        if (rb == null) {
            ResourceBundle bundle = ResourceBundle.getBundle(pkg + name);
            String kf = bundle.containsKey(KEYS_FORMAT) ? bundle.getString(KEYS_FORMAT) : "error.%d";
            rb = new BundleHolder(bundle, kf);
            BUNDLES.put(pkg, rb);
        }
        return rb;
    }
}

