/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw;

import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import ru.softlogic.hdw.Util;

public final class Flags {
    private static final String WRONG_KEY = "W/K";
    private static final Map<String, ResourceBundle> BUNDLES = new HashMap<String, ResourceBundle>();

    private Flags() {
    }

    public static String asString(Class context, String key, int flags) {
        ResourceBundle rb = Util.getBundle(BUNDLES, context, ".flags");
        try {
            int count = Integer.parseInt(rb.getString(key + ".count"));
            int mask = Integer.parseInt(rb.getString(key + ".mask"), 16);
            String dropKey = key + ".drops";
            boolean drops = rb.containsKey(dropKey) ? Boolean.parseBoolean(rb.getString(dropKey)) : false;
            String valueKey = key + ".value." + String.format("%X", flags);
            if (rb.containsKey(valueKey)) {
                return rb.getString(valueKey);
            }
            StringBuilder sb = new StringBuilder();
            int curr = 1;
            for (int i = 0; i < count; ++i) {
                if ((curr & mask) != 0) {
                    boolean set = (curr & flags) != 0;
                    String bv = null;
                    if (set) {
                        bv = rb.getString(key + "." + String.format("%X", curr) + ".1");
                    } else if (drops) {
                        bv = rb.getString(key + "." + String.format("%X", curr) + ".0");
                    }
                    if (bv != null) {
                        if (sb.length() != 0) {
                            sb.append(",");
                        }
                        sb.append(bv);
                    }
                }
                curr <<= 1;
            }
            return sb.toString();
        }
        catch (NumberFormatException | MissingResourceException ex) {
            ex.printStackTrace();
            return WRONG_KEY;
        }
    }
}

