/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public class DeviceClass {
    private static final ResourceBundle bundle = ResourceBundle.getBundle(DeviceClass.class.getPackage().getName() + ".messages");
    private static final Map<Short, String> map = new HashMap<Short, String>();
    public static final short POS_PRINTER = 0;
    public static final short IPP_PRINTER = 1;
    public static final short KKM_PRINTER = 2;
    public static final short BILL_ACCEPTOR = 3;
    public static final short COIN_ACCEPTOR = 4;
    public static final short WATCHDOG = 5;
    public static final short MODEM = 6;
    public static final short CARD_READER = 7;
    public static final short ENCRYPTED_PIN_PAD = 8;
    public static final short BARCODE_SCANNER = 10;
    public static final short PROXIMITY_READER = 11;
    public static final short TOUCH_SCREEN = 13;
    public static final short CARD_DISPENSER = 15;
    public static final short BILL_DISPENSER = 16;
    public static final short COFFEE_DISPENSER = 17;
    public static final short COIN_DISPENSER = 18;
    public static final short DISPLAY = 19;
    public static final short SENSORS = 20;
    public static final short IO_CONTROLLER = 21;
    public static final short SNACK_DISPENSER = 22;
    public static final short WEBCAM = 23;
    public static final short PCSC_READER = 24;
    public static final short BANK_CARD_MODULE = 50;
    public static final short UNKNOWN = 99;
    public static final String CARD_DISPENSER_S = "cvd";
    public static final String BILL_DISPENSER_S = "bdm";
    public static final String COIN_DISPENSER_S = "cdm";
    public static final String BILL_ACCEPTOR_S = "bvr";
    public static final String COIN_ACCEPTOR_S = "cvr";
    public static final String MODEM_S = "mod";
    public static final String WATCHDOG_S = "wdt";
    public static final String CARD_READER_S = "crd";
    public static final String PINPAD_S = "epp";
    public static final String BARCODE_S = "bar";
    public static final String POS_PRINTER_S = "pos";
    public static final String KKM_PRINTER_S = "kkm";
    public static final String SENSORS_S = "snr";
    public static final String IO_CONTROLLER_S = "ioc";
    public static final String BANK_CARD_MODULE_S = "bcm";
    public static final String WEBCAM_S = "wcm";
    public static final String BARCODE_SCANNER_S = "bar";

    public static String getCode(short deviceClass) {
        return map.get(deviceClass);
    }

    public static String asStr(short deviceClass) {
        String key = "class." + deviceClass;
        try {
            return bundle.getString(key);
        }
        catch (Exception ex) {
            return "unknown";
        }
    }

    public static String asTitleStr(int deviceClass) {
        String key = "class.title." + deviceClass;
        try {
            return bundle.getString(key);
        }
        catch (Exception ex) {
            return "unknown";
        }
    }

    static {
        map.put((short)3, BILL_ACCEPTOR_S);
        map.put((short)4, COIN_ACCEPTOR_S);
        map.put((short)16, BILL_DISPENSER_S);
        map.put((short)18, COIN_DISPENSER_S);
        map.put((short)0, POS_PRINTER_S);
        map.put((short)2, KKM_PRINTER_S);
        map.put((short)10, "bar");
        map.put((short)7, CARD_READER_S);
        map.put((short)15, CARD_DISPENSER_S);
        map.put((short)23, WEBCAM_S);
    }
}

