/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw;

import ru.softlogic.hdw.Flags;

public class BitMask {
    private final int mask;
    private final String description;

    public BitMask(Class context, String key, int mask) {
        this.mask = mask;
        this.description = Flags.asString(context, key, mask);
    }

    public int getMask() {
        return this.mask;
    }

    public boolean hasFlag(int flag) {
        return (this.mask & flag) != 0;
    }

    public String toString() {
        return "BitMask{mask=" + this.mask + (this.mask < 0 || this.mask > 8 ? String.format("/%Xh", this.mask) : "") + ", desc=" + this.description + '}';
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + this.mask;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BitMask other = (BitMask)obj;
        return this.mask == other.mask;
    }
}

