/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.search;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.lookup.DeviceDescription;
import ru.softlogic.hardware.search.BreakException;
import ru.softlogic.hardware.search.ComplexSearchable;
import ru.softlogic.hardware.search.NotFoundException;
import ru.softlogic.hardware.search.PortSearcherListener;
import ru.softlogic.hardware.search.SearchFilter;
import ru.softlogic.hardware.search.Searchable;
import ru.softlogic.hardware.search.SearchableFactory;
import ru.softlogic.hardware.search.SearchablePriorityComparator;
import ru.softlogic.hardware.search.UsbConnectedDevice;
import ru.softlogic.io.usb.UsbPort;

class UsbPortSearcher {
    private UsbPort port;
    private Collection<DeviceDescription> descriptions;
    private SearchFilter filter;
    private PortSearcherListener searcherListener;
    private int order;
    private boolean getInfo;
    private boolean cancel;
    Logger log = Logger.getLogger((String)"port-searcher");

    public UsbPortSearcher(UsbPort port, Collection<DeviceDescription> descriptions, SearchFilter filter, PortSearcherListener listener, int order, boolean getInfo) {
        if (port == null) {
            throw new NullPointerException("UsbPort");
        }
        if (descriptions == null) {
            throw new NullPointerException("DeviceDescription");
        }
        if (filter == null) {
            throw new NullPointerException("SearchFilter");
        }
        this.port = port;
        this.descriptions = descriptions;
        this.filter = filter;
        this.searcherListener = listener;
        this.order = order;
        this.getInfo = getInfo;
    }

    public void cancel() {
        this.cancel = true;
    }

    public UsbConnectedDevice search() {
        try {
            long total1 = System.currentTimeMillis();
            LinkedList<ComplexSearchable> ses = new LinkedList<ComplexSearchable>();
            for (DeviceDescription dd : this.descriptions) {
                this.info("try " + dd);
                if (this.filter.isAllowed(dd, this.port.getName())) {
                    Searchable src = SearchableFactory.create(dd.getCategory(), dd.getType());
                    if (src != null && src.getUsbSearchable() != null) {
                        ses.add(new ComplexSearchable(src, dd));
                        continue;
                    }
                    this.info("Searchable of " + dd.getType() + " is not found");
                    continue;
                }
                this.info("Not allowed");
            }
            this.checkCancel();
            if (!ses.isEmpty()) {
                Collections.sort(ses, new SearchablePriorityComparator());
                for (ComplexSearchable cs : ses) {
                    this.checkCancel();
                    DeviceDescription dd = cs.getDescription();
                    if (!this.filter.isAllowed(dd, this.port.getName())) continue;
                    this.info("Search: " + dd.getName());
                    Searchable src = cs.getSearchable();
                    this.info("    On params priority: " + this.order);
                    long st = System.currentTimeMillis();
                    if (!this.filter.isAllowed(dd, this.port.getName())) continue;
                    try {
                        DeviceDescription dsc = src.getUsbSearchable().search(this.port);
                        if (dsc != null) {
                            this.notifyProgress(dsc);
                        }
                        this.info("    >>>Found, " + this.port.getName() + ", timeout=" + (System.currentTimeMillis() - st) + " ms" + (dsc != null ? ", ANOTHER TYPE: " + dsc : ""));
                        this.info("    ***Total scan timeout: " + (System.currentTimeMillis() - total1) + " ms");
                        DeviceDescription res = dsc == null ? cs.getDescription() : dsc;
                        this.filter.onFound(res);
                        String identity = null;
                        if (this.getInfo) {
                            identity = src.getUsbSearchable().identity(this.port);
                        }
                        return new UsbConnectedDevice(this.port, res, identity);
                    }
                    catch (NotFoundException ex) {
                        this.info("    Not found " + dd.getCategory() + ":" + dd.getType() + ", timeout=" + (System.currentTimeMillis() - st) + " ms");
                    }
                }
                this.info("    Total scan timeout: " + (System.currentTimeMillis() - total1) + " ms");
            } else {
                this.info("Searchable for usb2lp ports are't found");
            }
        }
        catch (BreakException ex) {
            return null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private void checkCancel() throws BreakException {
        if (this.cancel) {
            throw new BreakException("Search is break");
        }
    }

    private void notifyProgress(DeviceDescription dd) {
        if (this.searcherListener != null) {
            this.searcherListener.onProgres(dd, "");
        }
    }

    private void info(Object message) {
        this.log.error((Object)(String.format("%5s", this.port.getName()) + "# " + message));
    }
}

