/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.search;

import java.util.Collection;
import ru.softlogic.hardware.lookup.DeviceDescription;
import ru.softlogic.hardware.search.ConnectedDeviceResult;
import ru.softlogic.hardware.search.PortRunnable;
import ru.softlogic.hardware.search.SearchFilter;
import ru.softlogic.hardware.search.SearchListener;
import ru.softlogic.hardware.search.UsbConnectedDevice;
import ru.softlogic.hardware.search.UsbPortSearcher;
import ru.softlogic.hardware.search.UsblConnectedDeviceResult;
import ru.softlogic.io.usb.UsbPort;

public class UsbPortRunnable
implements PortRunnable {
    private final UsbPort port;
    private final Collection<DeviceDescription> dds;
    private final SearchFilter filter;
    private final int deep;
    private final boolean getInfo;
    private final SearchListener searchListener;
    private boolean cancel;
    private UsbPortSearcher portSearcher;
    private final Object sync = new Object();

    public UsbPortRunnable(UsbPort port, Collection<DeviceDescription> dds, SearchFilter filter, SearchListener searchListener, int deep, boolean getInfo) {
        this.port = port;
        this.dds = dds;
        this.filter = filter;
        this.searchListener = searchListener;
        this.deep = deep;
        this.getInfo = getInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Object object = this.sync;
        synchronized (object) {
            this.cancel = true;
            if (this.portSearcher != null) {
                this.portSearcher.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectedDeviceResult call() throws Exception {
        this.onBegin();
        for (int i = 0; i < this.deep; ++i) {
            Object object = this.sync;
            synchronized (object) {
                if (this.cancel) {
                    this.onResult(null);
                    return null;
                }
                this.portSearcher = new UsbPortSearcher(this.port, this.dds, this.filter, this, i, this.getInfo);
            }
            UsbConnectedDevice res = this.portSearcher.search();
            if (res == null) continue;
            this.onResult(res);
            return new UsblConnectedDeviceResult(res);
        }
        this.onResult(null);
        return null;
    }

    public String getPort() {
        return this.port.getName();
    }

    @Override
    public void onProgres(DeviceDescription dd, String params) {
        if (this.searchListener != null) {
            this.searchListener.onProgress(this.port.getName(), dd, params);
        }
    }

    public void onBegin() {
        if (this.searchListener != null) {
            this.searchListener.onBegin(this.port.getName());
        }
    }

    public void onResult(UsbConnectedDevice cd) {
        if (this.searchListener != null) {
            this.searchListener.onResult(this.port.getName(), cd);
        }
    }
}

