/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.search;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.lookup.DeviceDescription;
import ru.softlogic.hardware.search.BreakException;
import ru.softlogic.hardware.search.ComplexSearchable;
import ru.softlogic.hardware.search.ConnectedDevice;
import ru.softlogic.hardware.search.NotFoundException;
import ru.softlogic.hardware.search.PortSearcherListener;
import ru.softlogic.hardware.search.SearchFilter;
import ru.softlogic.hardware.search.Searchable;
import ru.softlogic.hardware.search.SearchableFactory;
import ru.softlogic.hardware.search.SearchablePriorityComparator;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;

class SerialPortSearcher {
    private SerialPort port;
    private Collection<DeviceDescription> descriptions;
    private ConnectedDevice current;
    private SearchFilter filter;
    private PortSearcherListener searcherListener;
    private int order;
    private boolean getInfo;
    private boolean cancel;
    Logger log = Logger.getLogger((String)"port-searcher");

    public SerialPortSearcher(SerialPort port, Collection<DeviceDescription> descriptions, ConnectedDevice current, SearchFilter filter, PortSearcherListener listener, int order, boolean getInfo) {
        if (port == null) {
            throw new NullPointerException("SerialPort");
        }
        if (descriptions == null) {
            throw new NullPointerException("DeviceDescription");
        }
        if (filter == null) {
            throw new NullPointerException("SearchFilter");
        }
        this.port = port;
        this.descriptions = descriptions;
        this.current = current;
        this.filter = filter;
        this.searcherListener = listener;
        this.order = order;
        this.getInfo = getInfo;
    }

    public void cancel() {
        this.cancel = true;
    }

    public ConnectedDevice search() {
        try {
            Searchable src;
            long total1 = System.currentTimeMillis();
            if (this.current != null && this.descriptions.contains(this.current.getDescription()) && (src = SearchableFactory.create(this.current.getDescription().getCategory(), this.current.getDescription().getType())) != null && src.getSerialSearchable() != null) {
                try {
                    this.info("Search previos device on port: " + this.port.getName());
                    this.notifyProgress(this.current.getDescription(), this.current.getPort().getParams());
                    DeviceDescription dd = src.getSerialSearchable().search(this.current.getPort());
                    if (dd != null) {
                        this.notifyProgress(dd, this.current.getPort().getParams());
                    }
                    this.info("    >>>Found, " + this.current.getPort() + "," + this.current.getPort().getParams() + (dd != null ? ", ANOTHER TYPE: " + dd : ""));
                    DeviceDescription res = dd == null ? this.current.getDescription() : dd;
                    this.filter.onFound(res);
                    return new ConnectedDevice(this.port, res);
                }
                catch (NotFoundException ex) {
                    this.info("    Not found");
                }
            }
            this.checkCancel();
            LinkedList<ComplexSearchable> ses = new LinkedList<ComplexSearchable>();
            for (DeviceDescription dd : this.descriptions) {
                if (!this.filter.isAllowed(dd, this.port.getName())) continue;
                Searchable src2 = SearchableFactory.create(dd.getCategory(), dd.getType());
                if (src2 != null && src2.getSerialSearchable().canSearch(this.port)) {
                    ses.add(new ComplexSearchable(src2, dd));
                    continue;
                }
                this.info("Searchable of " + dd.getType() + " is not found");
            }
            this.checkCancel();
            if (!ses.isEmpty()) {
                Collections.sort(ses, new SearchablePriorityComparator());
                for (ComplexSearchable cs : ses) {
                    this.checkCancel();
                    DeviceDescription dd = cs.getDescription();
                    if (!this.filter.isAllowed(dd, this.port.getName())) continue;
                    this.info("Search: " + dd.getName());
                    Searchable src3 = cs.getSearchable();
                    this.info("    On params priority: " + this.order);
                    SerialParams[] params = src3.getSerialSearchable().getSearchParams(this.order);
                    if (params == null || params.length == 0) {
                        this.info("    Continue");
                        continue;
                    }
                    long st = System.currentTimeMillis();
                    for (SerialParams sp : params) {
                        this.checkCancel();
                        this.notifyProgress(dd, sp);
                        if (!this.filter.isAllowed(dd, this.port.getName())) continue;
                        this.info("    " + sp);
                        this.port.putParams(sp);
                        try {
                            SerialPort sep = new SerialPort(this.port.getName(), sp);
                            DeviceDescription dsc = src3.getSerialSearchable().search(sep);
                            if (dsc != null) {
                                this.notifyProgress(dsc, sp);
                            }
                            this.info("    >>>Found, " + this.port.getName() + "," + this.port.getParams() + ", timeout=" + (System.currentTimeMillis() - st) + " ms" + (dsc != null ? ", ANOTHER TYPE: " + dsc : ""));
                            this.info("    ***Total scan timeout: " + (System.currentTimeMillis() - total1) + " ms");
                            DeviceDescription res = dsc == null ? cs.getDescription() : dsc;
                            this.filter.onFound(res);
                            String identity = null;
                            if (this.getInfo) {
                                identity = src3.getSerialSearchable().identity(this.port);
                            }
                            return new ConnectedDevice(this.port, res, identity);
                        }
                        catch (NotFoundException ex) {
                            this.info("    Not found " + dd.getCategory() + ":" + dd.getType() + ", params=" + sp + ", timeout=" + (System.currentTimeMillis() - st) + " ms");
                        }
                        catch (Throwable ex) {
                            this.log.error((Object)"Unknown error", ex);
                        }
                    }
                }
                this.info("    Total scan timeout: " + (System.currentTimeMillis() - total1) + " ms");
            }
        }
        catch (BreakException ex) {
            return null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private void checkCancel() throws BreakException {
        if (this.cancel) {
            throw new BreakException("Search is break");
        }
    }

    private void notifyProgress(DeviceDescription dd, SerialParams params) {
        if (this.searcherListener != null) {
            this.searcherListener.onProgres(dd, params.toString());
        }
    }

    private void info(Object message) {
        this.log.info((Object)(String.format("%5s", this.port.getName()) + "# " + message));
    }
}

