/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.search;

import java.util.Collection;
import ru.softlogic.hardware.lookup.DeviceDescription;
import ru.softlogic.hardware.search.ConnectedDevice;
import ru.softlogic.hardware.search.ConnectedDeviceResult;
import ru.softlogic.hardware.search.PortRunnable;
import ru.softlogic.hardware.search.SearchFilter;
import ru.softlogic.hardware.search.SearchListener;
import ru.softlogic.hardware.search.SerialConnectedDeviceResult;
import ru.softlogic.hardware.search.SerialPortSearcher;
import ru.softlogic.io.serial.SerialPort;

public class SerialPortRunnable
implements PortRunnable {
    private final SerialPort port;
    private final Collection<DeviceDescription> dds;
    private final ConnectedDevice cd;
    private final SearchFilter filter;
    private final int deep;
    private final boolean getInfo;
    private final SearchListener searchListener;
    private boolean cancel;
    private SerialPortSearcher portSearcher;
    private final Object sync = new Object();

    public SerialPortRunnable(SerialPort port, Collection<DeviceDescription> dds, ConnectedDevice cd, SearchFilter filter, SearchListener searchListener, int deep, boolean getInfo) {
        this.port = port;
        this.dds = dds;
        this.cd = cd;
        this.filter = filter;
        this.searchListener = searchListener;
        this.deep = deep;
        this.getInfo = getInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Object object = this.sync;
        synchronized (object) {
            this.cancel = true;
            if (this.portSearcher != null) {
                this.portSearcher.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectedDeviceResult call() throws Exception {
        this.onBegin();
        for (int i = 0; i < this.deep; ++i) {
            Object object = this.sync;
            synchronized (object) {
                if (this.cancel) {
                    this.onResult(null);
                    return null;
                }
                this.portSearcher = new SerialPortSearcher(this.port, this.dds, i == 0 ? this.cd : null, this.filter, this, i, this.getInfo);
            }
            ConnectedDevice res = this.portSearcher.search();
            if (res == null) continue;
            this.onResult(res);
            return new SerialConnectedDeviceResult(res);
        }
        this.onResult(null);
        return null;
    }

    public String getPort() {
        return this.port.getName();
    }

    @Override
    public void onProgres(DeviceDescription dd, String params) {
        if (this.searchListener != null) {
            this.searchListener.onProgress(this.port.getName(), dd, params);
        }
    }

    public void onBegin() {
        if (this.searchListener != null) {
            this.searchListener.onBegin(this.port.getName());
        }
    }

    public void onResult(ConnectedDevice cd) {
        if (this.searchListener != null) {
            this.searchListener.onResult(this.port.getName(), cd);
        }
    }
}

