/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.search;

import ru.softlogic.hardware.lookup.DeviceDescription;
import ru.softlogic.hardware.search.SearchFilter;

public class AndSearchFilter
implements SearchFilter {
    private SearchFilter[] filters;

    public AndSearchFilter(SearchFilter ... filters) {
        if (filters == null) {
            throw new NullPointerException("Filters");
        }
        for (SearchFilter sf : filters) {
            if (sf != null) continue;
            throw new NullPointerException("Filters*");
        }
        this.filters = filters;
    }

    @Override
    public boolean isAllowed(DeviceDescription dd, String port) {
        for (SearchFilter sf : this.filters) {
            if (sf.isAllowed(dd, port)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void onFound(DeviceDescription dd) {
        for (SearchFilter sf : this.filters) {
            sf.onFound(dd);
        }
    }
}

