/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.lookup;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Manifest;
import ru.softlogic.hardware.lookup.DeviceDescription;
import ru.softlogic.hardware.lookup.LookupEngine;

class ManifestLookupEngine
extends LookupEngine {
    private ManifestLookupEngine() {
    }

    public static Set<DeviceDescription> lookup() {
        HashSet<DeviceDescription> devices = new HashSet<DeviceDescription>();
        try {
            StringBuilder sb = new StringBuilder();
            Enumeration<URL> resources = ManifestLookupEngine.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                try {
                    Manifest manifest = new Manifest(resources.nextElement().openStream());
                    String val = manifest.getMainAttributes().getValue("JavaFX-Class-Path");
                    if (val != null) {
                        sb.append(val).append(" ");
                    }
                    if ((val = manifest.getMainAttributes().getValue("Class-Path")) == null) continue;
                    sb.append(val).append(" ");
                }
                catch (IOException iOException) {}
            }
            for (String path : sb.toString().split(" ")) {
                if (!ManifestLookupEngine.canSearch(path)) continue;
                ManifestLookupEngine.process(path, devices);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return devices;
    }
}

