/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.lookup;

import java.io.Serializable;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import ru.softlogic.hardware.lookup.DeviceDescription;
import ru.softlogic.hardware.lookup.JarLookupEngine;
import ru.softlogic.hardware.lookup.ManifestLookupEngine;
import ru.softlogic.hardware.lookup.PropetyLookupEngine;

public class HardwareLookup {
    public static final String EPP = "epp";
    public static final String CARDREADER = "cardreader";
    public static final String CARD_VENDING_DISPENSER = "cvd";
    private static Set<DeviceDescription> devices;

    private HardwareLookup() {
    }

    public static synchronized Set<DeviceDescription> lookup() {
        if (devices == null) {
            String engine = System.getProperty("hardware.lookup.engine");
            if ("property".equals(engine)) {
                devices = PropetyLookupEngine.lookup();
            } else if ("manifest".equals(engine)) {
                devices = ManifestLookupEngine.lookup();
            } else if ("jar".equals(engine)) {
                devices = JarLookupEngine.lookup();
            } else {
                devices = new TreeSet<DeviceDescription>(new DescComparator());
                devices.addAll(PropetyLookupEngine.lookup());
                devices.addAll(ManifestLookupEngine.lookup());
                devices.addAll(JarLookupEngine.lookup());
            }
        }
        return devices;
    }

    public static Set<DeviceDescription> lookup(String category) {
        if (category == null) {
            return null;
        }
        HashSet<DeviceDescription> res = new HashSet<DeviceDescription>();
        for (DeviceDescription dd : HardwareLookup.lookup()) {
            if (!category.equals(dd.getCategory())) continue;
            res.add(dd);
        }
        return res;
    }

    private static class DescComparator
    implements Comparator<DeviceDescription>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private DescComparator() {
        }

        @Override
        public int compare(DeviceDescription o1, DeviceDescription o2) {
            int cat = o1.getCategory().compareTo(o2.getCategory());
            if (cat != 0) {
                return cat;
            }
            return o1.getType().compareTo(o2.getType());
        }
    }
}

