/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.currency.set;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import ru.softlogic.hardware.currency.CurrencyHelper;
import ru.softlogic.hardware.currency.DefaultComparator;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.hardware.currency.Sum;

public class DenominationSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<Denomination, Integer> map = new HashMap<Denomination, Integer>();

    public DenominationSet() {
    }

    public DenominationSet(Denomination den) {
        this.add(den);
    }

    public DenominationSet(Denomination den, int count) {
        this.add(den, count);
    }

    public DenominationSet(Map<Denomination, Integer> counts) {
        for (Map.Entry<Denomination, Integer> entry : counts.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
    }

    public final synchronized void add(Denomination denomination) {
        this.add(denomination, 1);
    }

    public final synchronized void add(Denomination denomination, int count) {
        if (denomination == null) {
            throw new NullPointerException("Denomination is null");
        }
        if (count <= 0) {
            throw new IllegalArgumentException("Count must be positive. Value is " + count);
        }
        Integer cnt = this.map.get(denomination);
        if (cnt == null) {
            this.map.put(denomination, count);
        } else {
            this.map.put(denomination, cnt + count);
        }
    }

    public final synchronized void remove(Denomination denomination, int count) {
        if (denomination == null) {
            throw new NullPointerException("Denomination is null");
        }
        if (count <= 0) {
            throw new IllegalArgumentException("Count must be positive. Value is " + count);
        }
        Integer cnt = this.map.get(denomination);
        if (cnt == null || cnt < count) {
            throw new IllegalArgumentException("Insufficient amount");
        }
        if (cnt == count) {
            this.map.remove(denomination);
        } else {
            this.map.put(denomination, cnt - count);
        }
    }

    public final synchronized void add(DenominationSet ds) {
        this.add(ds.map);
    }

    public final synchronized void add(Map<Denomination, Integer> set) {
        for (Map.Entry<Denomination, Integer> entry : set.entrySet()) {
            Integer cnt = this.map.get(entry.getKey());
            this.map.put(entry.getKey(), entry.getValue() + (cnt == null ? 0 : cnt));
        }
    }

    public synchronized String[] getCurrencies() {
        TreeSet<String> currs = new TreeSet<String>();
        for (Denomination d : this.map.keySet()) {
            currs.add(d.getCurrency());
        }
        return currs.toArray(new String[currs.size()]);
    }

    public synchronized Sum getTotal(String currency) {
        CurrencyHelper.checkCurrency(currency);
        int sum = 0;
        for (Map.Entry<Denomination, Integer> entry : this.map.entrySet()) {
            if (!currency.equals(entry.getKey().getCurrency())) continue;
            sum += entry.getKey().getNominal() * entry.getValue();
        }
        return new Sum(sum, currency);
    }

    public synchronized Denomination getMinDenomination(String currency) {
        CurrencyHelper.checkCurrency(currency);
        Denomination res = null;
        for (Denomination den : this.map.keySet()) {
            if (!currency.equals(den.getCurrency()) || res != null && res.getNominal() <= den.getNominal()) continue;
            res = den;
        }
        return res;
    }

    public synchronized Denomination getMaxDenomination(String currency) {
        Denomination res = null;
        for (Denomination den : this.map.keySet()) {
            if (!currency.equals(den.getCurrency()) || res != null && res.getNominal() >= den.getNominal()) continue;
            res = den;
        }
        return res;
    }

    public synchronized List<Sum> getTotals() {
        TreeMap<String, Integer> res = new TreeMap<String, Integer>();
        for (Map.Entry<Denomination, Integer> entry : this.map.entrySet()) {
            Denomination d = entry.getKey();
            Integer sum = (Integer)res.get(d.getCurrency());
            res.put(d.getCurrency(), d.getNominal() * entry.getValue() + (sum != null ? sum : 0));
        }
        LinkedList<Sum> totals = new LinkedList<Sum>();
        for (Map.Entry total : res.entrySet()) {
            totals.add(new Sum((Integer)total.getValue(), (String)total.getKey()));
        }
        return totals;
    }

    public synchronized Map<Denomination, Integer> getCounts() {
        TreeMap<Denomination, Integer> res = new TreeMap<Denomination, Integer>(new DefaultComparator());
        res.putAll(this.map);
        return res;
    }

    public synchronized Map<Denomination, Integer> getCounts(String currency) {
        CurrencyHelper.checkCurrency(currency);
        TreeMap<Denomination, Integer> res = new TreeMap<Denomination, Integer>(new DefaultComparator());
        for (Map.Entry<Denomination, Integer> entry : this.map.entrySet()) {
            if (!currency.equals(entry.getKey().getCurrency())) continue;
            res.put(entry.getKey(), entry.getValue());
        }
        return res;
    }

    public synchronized Map<Denomination, Integer> empty() {
        Map<Denomination, Integer> res = this.map;
        this.map = new HashMap<Denomination, Integer>();
        return res;
    }

    public synchronized boolean isEmpty() {
        return this.map.isEmpty();
    }

    public synchronized int getTotalCount() {
        int total = 0;
        for (Integer count : this.map.values()) {
            total += count.intValue();
        }
        return total;
    }

    public final synchronized boolean enough(DenominationSet ds) {
        for (Map.Entry<Denomination, Integer> entry : ds.map.entrySet()) {
            Integer cnt = this.map.get(entry.getKey());
            if (cnt != null && cnt >= entry.getValue()) continue;
            return false;
        }
        return true;
    }

    public synchronized double getRatio(Denomination denomination) {
        if (this.map.isEmpty()) {
            return 0.0;
        }
        Integer cnt = this.map.get(denomination);
        if (cnt == null || cnt == 0) {
            return 0.0;
        }
        return (double)cnt.intValue() * 1.0 / (double)this.getTotalCount();
    }

    public synchronized Map<Denomination, Double> getRatios() {
        int total = this.getTotalCount();
        TreeMap<Denomination, Double> res = new TreeMap<Denomination, Double>(new DefaultComparator());
        if (total > 0) {
            for (Map.Entry<Denomination, Integer> entry : this.map.entrySet()) {
                res.put(entry.getKey(), (double)entry.getValue().intValue() * 1.0 / (double)total);
            }
        }
        return res;
    }

    public String toString() {
        return "DenominationSet{map=" + this.map + '}';
    }
}

