/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.currency.add;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.hardware.currency.Sum;

public class MultiCurrencyKeeper {
    private final Set<String> currencies;
    private final Map<Denomination, Integer> map = new HashMap<Denomination, Integer>();

    public MultiCurrencyKeeper(Set<String> currencies) {
        if (currencies == null) {
            throw new NullPointerException("Currencies is null");
        }
        for (String curr : currencies) {
            if (curr == null) {
                throw new NullPointerException("Currency in set is null");
            }
            if (curr.length() == 3) continue;
            throw new IllegalArgumentException("Wrong currency code: " + curr);
        }
        this.currencies = Collections.unmodifiableSet(currencies);
    }

    public Set<String> getCurrencies() {
        return this.currencies;
    }

    public Sum getSum(String currency) {
        if (currency == null) {
            throw new NullPointerException("Currency is null");
        }
        if (currency.length() != 3) {
            throw new IllegalArgumentException("Wrong currency code: " + currency);
        }
        if (!this.currencies.contains(currency)) {
            throw new IllegalArgumentException("Keeper is not support currency: " + currency);
        }
        int value = 0;
        for (Denomination den : this.map.keySet()) {
            if (!den.getCurrency().equals(currency)) continue;
            int cnt = this.map.get(den);
            value += den.getNominal() * cnt;
        }
        return new Sum(value, currency);
    }

    public void add(Denomination denomination) {
        this.add(denomination, 1);
    }

    public void add(Denomination denomination, int count) {
        if (denomination == null) {
            throw new NullPointerException("Denomination is null");
        }
        if (!this.currencies.contains(denomination.getCurrency())) {
            throw new IllegalArgumentException("Keeper is not support currency: " + denomination.getCurrency());
        }
        if (count <= 0) {
            throw new IllegalArgumentException("Count must be positive. Value is " + count);
        }
        Integer cnt = this.map.get(denomination);
        if (cnt == null) {
            this.map.put(denomination, count);
        } else {
            this.map.put(denomination, cnt + count);
        }
    }
}

