/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.currency;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.hardware.currency.Sum;

public class SumUtils {
    private SumUtils() {
    }

    public static Sum mul(Sum sum, int val) {
        SumUtils.checkSum(sum);
        return new Sum(sum.getValue() * val, sum.getCurrency());
    }

    public static Sum div(Sum sum, int val) {
        SumUtils.checkSum(sum);
        return new Sum(sum.getValue() / val, sum.getCurrency());
    }

    private static void checkSum(Sum sum) {
        if (sum == null) {
            throw new IllegalArgumentException("Sum is null");
        }
    }

    public static Sum calculate(Map<Denomination, Integer> set, String curr) {
        int sum = 0;
        for (Map.Entry<Denomination, Integer> e : set.entrySet()) {
            if (!e.getKey().getCurrency().equals(curr)) continue;
            sum += e.getValue() * e.getKey().getNominal();
        }
        return new Sum(sum, curr);
    }

    public static Sum calculate(List<Denomination> list, String curr) {
        int sum = 0;
        for (Denomination d : list) {
            if (!d.getCurrency().equals(curr)) continue;
            sum += d.getNominal();
        }
        return new Sum(sum, curr);
    }

    public static Map<Denomination, Integer> merge(Map<Denomination, Integer> m1, Map<Denomination, Integer> m2) {
        if (m1 == null) {
            throw new NullPointerException("Map1 is null");
        }
        if (m2 == null) {
            throw new NullPointerException("Map2 is null");
        }
        HashMap<Denomination, Integer> res = new HashMap<Denomination, Integer>();
        res.putAll(m1);
        for (Map.Entry<Denomination, Integer> e : m2.entrySet()) {
            Integer value = e.getValue();
            res.put(e.getKey(), (value != null ? value : 0) + e.getValue());
        }
        return res;
    }
}

