/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.currency;

public class Dimensions {
    public static final Dimensions DEFAULT = new Dimensions(150, 65, 120);
    public static final int MIN_WIDTH = 55;
    public static final int MAX_WIDTH = 85;
    public static final int MIN_LENGTH = 110;
    public static final int MAX_LENGTH = 172;
    public static final int MIN_THICKNESS = 60;
    public static final int MAX_THICKNESS = 180;
    private final int length;
    private final int width;
    private final int thickness;

    public Dimensions(int length, int width, int thickness) {
        if (length < 110) {
            throw new IllegalArgumentException("Length is wrong: " + length);
        }
        if (width < 55 || width > 85) {
            throw new IllegalArgumentException("Width is wrong: " + width);
        }
        if (thickness < 60 || thickness > 180) {
            throw new IllegalArgumentException("Thickness is wrong: " + thickness);
        }
        this.length = length;
        this.width = width;
        this.thickness = thickness;
    }

    public int getLength() {
        return this.length;
    }

    public int getWidth() {
        return this.width;
    }

    public int getThickness() {
        return this.thickness;
    }

    public int hashCode() {
        int hash = 3;
        hash = 89 * hash + this.length;
        hash = 89 * hash + this.width;
        hash = 89 * hash + this.thickness;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Dimensions other = (Dimensions)obj;
        if (this.length != other.length) {
            return false;
        }
        if (this.width != other.width) {
            return false;
        }
        return this.thickness == other.thickness;
    }

    public String toString() {
        return "Dimensions{" + this.length + "x" + this.width + " " + this.thickness + '}';
    }
}

