/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.currency;

import java.io.Serializable;

public class Denomination
implements Serializable {
    private static final long serialVersionUID = -2809549228195542436L;
    public static final int TYPE_NOTE = 0;
    public static final int TYPE_COIN = 1;
    private final int id;
    private final int type;
    private final int nominal;
    private final String currency;

    public Denomination(int id, int type, int nominal, String currency) {
        if (type != 1 && type != 0) {
            throw new IllegalArgumentException("Type is wrong");
        }
        if (nominal <= 0) {
            throw new IllegalArgumentException("Nominal must be positive");
        }
        if (currency == null) {
            throw new NullPointerException("Currency is null");
        }
        if (currency.trim().length() != 3) {
            throw new IllegalArgumentException("Wrong currency code: " + currency);
        }
        this.id = id;
        this.type = type;
        this.nominal = nominal;
        this.currency = currency;
    }

    public int getId() {
        return this.id;
    }

    public int getNominal() {
        return this.nominal;
    }

    public String getCurrency() {
        return this.currency;
    }

    public int getType() {
        return this.type;
    }

    public String toString() {
        return "Denomination{id=" + this.id + ", type=" + (this.type == 0 ? "NOTE" : "COIN") + ", nominal=" + this.nominal + ", currency=" + this.currency + '}';
    }

    public int hashCode() {
        int hash = 3;
        hash = 43 * hash + this.id;
        hash = 43 * hash + this.type;
        hash = 43 * hash + this.nominal;
        hash = 43 * hash + (this.currency != null ? this.currency.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Denomination other = (Denomination)obj;
        if (this.id != other.id) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        if (this.nominal != other.nominal) {
            return false;
        }
        return !(this.currency == null ? other.currency != null : !this.currency.equals(other.currency));
    }
}

