/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.currency;

import java.util.Locale;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.hardware.currency.WrongNominalException;

public class CashProfile {
    private final String code;
    private final Denomination[] bills;
    private final Denomination[] coins;
    private final Denomination minCoin;
    private final Denomination minBill;
    private final int decimals;
    private final int scale;
    private final int coinScale;
    private final Locale locale;
    private final Denomination maxCoin;
    private final Denomination maxBill;
    private final String template;

    public CashProfile(String code, Denomination[] bills, Denomination minBill, Denomination[] coins, Denomination minCoin, int decimals, int coinScale, Locale locale) {
        this(code, bills, minBill, coins, minCoin, decimals, coinScale, locale, null);
    }

    public CashProfile(String code, Denomination[] bills, Denomination minBill, Denomination[] coins, Denomination minCoin, int decimals, int coinScale, Locale locale, String template) {
        this.code = code;
        this.bills = bills;
        this.coins = coins;
        this.minBill = minBill;
        this.minCoin = minCoin;
        this.decimals = decimals;
        this.scale = (int)Math.pow(10.0, decimals);
        this.coinScale = coinScale;
        this.locale = locale;
        this.template = template;
        this.maxBill = this.getMax(bills);
        this.maxCoin = this.getMax(coins);
    }

    public Denomination[] getBills() {
        return this.bills;
    }

    public Denomination getMinBill() {
        return this.minBill;
    }

    public Denomination getMinCoin() {
        return this.minCoin;
    }

    public Denomination getBill(int nominal) throws WrongNominalException {
        if (this.bills != null) {
            for (Denomination d : this.bills) {
                if (d.getNominal() != nominal) continue;
                return d;
            }
        }
        throw new WrongNominalException("Wrong bill nominal " + nominal + " for currency " + this.code);
    }

    public Denomination[] getCoins() {
        return this.coins;
    }

    public Denomination getMaxCoin() {
        return this.maxCoin;
    }

    public Denomination getMaxBill() {
        return this.maxBill;
    }

    public Denomination getCoin(int nominal) throws WrongNominalException {
        int n = nominal * this.getCoinScaleFactor();
        if (this.coins != null) {
            for (Denomination d : this.coins) {
                if (d.getNominal() != n) continue;
                return d;
            }
        }
        throw new WrongNominalException("Wrong bill nominal " + nominal + " for currency " + this.code);
    }

    public int getDecimals() {
        return this.decimals;
    }

    public int getScale() {
        return this.scale;
    }

    public int getCoinScaleFactor() {
        return this.coinScale;
    }

    public String getCode() {
        return this.code;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getTemplate() {
        return this.template;
    }

    public String toString() {
        return "CashProfile{code=" + this.code + ", scale=" + this.scale + '}';
    }

    private Denomination getMax(Denomination[] denominations) {
        Denomination res = null;
        if (denominations != null) {
            for (Denomination d : denominations) {
                if (res != null && res.getNominal() >= d.getNominal()) continue;
                res = d;
            }
        }
        return res;
    }
}

