/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.config;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.softlogic.config.BaseSection;
import ru.softlogic.hdw.base.SerialDevConfiguration;
import ru.softlogic.io.PortScanner;
import ru.softlogic.io.PortType;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;

public abstract class SerialDeviceSection
extends BaseSection {
    public static final String ENABLE = "active";
    public static final String DRIVER = "driver";
    public static final String PORT = "port";
    public static final String LOGICAL_NAME = "logical-name";

    @Override
    public String getGroup() {
        return "hardware";
    }

    public final Element generate(Document doc, SerialDevConfiguration sdc) {
        if (sdc != null) {
            Element root = doc.createElement(this.getKey());
            if (!sdc.isEnable()) {
                root.setAttribute(ENABLE, Boolean.toString(sdc.isEnable()));
            }
            root.setAttribute(DRIVER, sdc.getType());
            root.setAttribute(PORT, this.formatSerial(sdc.getPort()));
            if (sdc.getLogicalName() != null) {
                root.setAttribute(LOGICAL_NAME, sdc.getLogicalName());
            }
            this.generateOptions(doc, root);
            return root;
        }
        return null;
    }

    protected String formatSerial(SerialPort port) {
        if (port != null) {
            return port.getName() + ":" + port.getParams().getSpeed() + "," + port.getParams().getDataBits().getCode() + "," + port.getParams().getStopBits().getName() + "," + port.getParams().getParity();
        }
        return "";
    }

    protected String getDriver(Element element) {
        return element.getAttribute(DRIVER);
    }

    protected String getLogicalName(Element element) {
        if (element.hasAttribute(LOGICAL_NAME)) {
            return element.getAttribute(LOGICAL_NAME);
        }
        return null;
    }

    protected boolean getEnable(Element element) {
        return this.readBoolean(element.getAttribute(ENABLE), true);
    }

    protected SerialPort getSerialPort(Element element) {
        String port = element.getAttribute(PORT);
        String[] paths = port.split(":");
        if (paths.length != 2) {
            return null;
        }
        if (!PortType.SerialPort.equals((Object)PortScanner.suggestType((String)paths[0]))) {
            return null;
        }
        if (!paths[1].matches("\\d+,\\d,\\d,(None|Odd|Even|Mark|Space)")) {
            return null;
        }
        String[] pr = paths[1].split(",");
        return new SerialPort(paths[0], new SerialParams(Integer.parseInt(pr[0]), DataBits.value((String)pr[1]), StopBits.value((String)pr[2]), Parity.valueOf((String)pr[3])));
    }

    protected abstract void generateOptions(Document var1, Element var2);
}

