/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.config;

import java.io.File;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import ru.softlogic.config.ParceException;
import ru.softlogic.config.Section;

public class ConfigurationIO {
    private final File file;
    private final Logger log;

    public ConfigurationIO(File file, Logger log) {
        if (file == null) {
            throw new NullPointerException("File is null");
        }
        if (log == null) {
            throw new NullPointerException("Logger is null");
        }
        this.file = file;
        this.log = log;
    }

    public void update(List<Section> sections) throws Exception {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element root = doc.createElement("root");
            doc.appendChild(root);
            root.appendChild(doc.createComment("======================================================================"));
            String on = System.getProperty("os.name");
            String ov = System.getProperty("os.version");
            String jv = System.getProperty("java.version");
            root.appendChild(doc.createComment(String.format("%70s", "Generated " + new Date() + "," + on + "(" + ov + ")," + jv + "")));
            for (Section sec : sections) {
                Node el;
                Element r = root;
                if (sec.getGroup() != null && (r = this.getElement(root, sec.getGroup())) == null) {
                    root.appendChild(doc.createComment("======================================================================"));
                    r = doc.createElement(sec.getGroup());
                    root.appendChild(r);
                }
                if ((el = sec.generate(doc)) == null) continue;
                r.appendChild(el);
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(this.file);
            transformer.transform(source, result);
        }
        catch (DOMException ex) {
            throw new Exception("Error on safe config", ex);
        }
    }

    public void load(List<Section> sections) throws Exception {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(this.file);
            Element root = doc.getDocumentElement();
            doc.getDocumentElement().normalize();
            for (Section sec : sections) {
                Element el;
                Element r = root;
                if (sec.getGroup() != null) {
                    r = this.getElement(root, sec.getGroup());
                }
                if (r == null || (el = this.getElement(r, sec.getKey())) == null) continue;
                try {
                    sec.parce(el);
                }
                catch (ParceException ex) {
                    this.log.info((Object)("Error on load section " + sec.getKey()), (Throwable)ex);
                }
            }
        }
        catch (SAXException ex) {
            throw new Exception("Error on load file", ex);
        }
    }

    private Element getElement(Element root, String name) {
        NodeList nl = root.getElementsByTagName(name);
        if (nl.getLength() > 0) {
            return (Element)nl.item(0);
        }
        return null;
    }
}

