/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.epp.stubconsole.driver.handler;

import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.epp.stub.driver.handler.Handler;
import ru.softlogic.hdw.TaskBus;
import ru.softlogic.hdw.dev.epp.EppPlainPinListener;
import ru.softlogic.hdw.dev.epp.PlainPinRequest;

public class PlainPinHandler
implements Handler {
    private final TaskBus bus;
    private final PlainPinRequest request;
    private final int comleteLen;
    private final int timeout;
    private final Logger log;
    private final EppPlainPinListener listener;
    private boolean complete;

    public PlainPinHandler(TaskBus bus, PlainPinRequest request, int comleteLen, int timeout, Logger log) {
        this.bus = bus;
        this.request = request;
        this.comleteLen = comleteLen;
        this.timeout = timeout;
        this.log = log;
        this.listener = request.getListener();
    }

    private void notifyError(int error) {
        this.bus.addTask((Runnable)new ErrorRunner(error));
    }

    private void notifySpec(int key) {
        this.bus.addTask((Runnable)new KeyPressRunner(key));
    }

    private void notifyPlain(String plain) {
        this.bus.addTask((Runnable)new PlainRunner(plain));
    }

    private void notifyKeys(byte[] data) {
        if (data == null || data.length == 0 || this.listener == null) {
            return;
        }
        for (byte b2 : data) {
            char c = (char)b2;
            if (Character.isDigit(c)) {
                this.listener.onPressKey('*');
                continue;
            }
            if (c == '.' || c == '\u001b' || c == '\b' || c == ' ' || c == '\n') continue;
            this.log.error((Object)("Unknown character: " + b2 + ", " + c));
        }
    }

    @Override
    public void run() {
        this.log.info((Object)"Start open pin handler");
        this.log.info((Object)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u041f\u0418\u041d:");
        try {
            int counter = this.timeout * 10;
            InputStream is = System.in;
            char[] buf = new char[20];
            int len = 0;
            while (!Thread.currentThread().isInterrupted()) {
                block11: {
                    try {
                        if (is.available() <= 0) break block11;
                        int read = is.read();
                        this.notifyKeys(new byte[]{(byte)(read & 0xFF)});
                        char c = (char)read;
                        if (Character.isDigit(c)) {
                            buf[len++] = c;
                            break block11;
                        }
                        if (c == '\u001b') {
                            this.notifyError(2);
                            break;
                        }
                        if (c == '\b') {
                            if (len > 0) {
                                --len;
                            }
                            this.notifySpec(2);
                            break block11;
                        }
                        if (c == ' ' || c != '\n') break block11;
                        if (len > 0) {
                            this.notifyPlain(new String(buf, 0, len));
                            break block11;
                        }
                        this.notifyError(2);
                    }
                    catch (IOException ex) {
                        this.notifyError(4);
                        this.log.error((Object)("error:" + ex.getMessage()), (Throwable)ex);
                    }
                    break;
                }
                if (this.timeout > 0 && --counter == 0) {
                    this.notifyError(1);
                    break;
                }
                Thread.sleep(100L);
            }
            this.complete = true;
            this.log.info((Object)"Open pin handler 'process' finish");
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    private class PlainRunner
    implements Runnable {
        private final String plain;

        public PlainRunner(String plain) {
            this.plain = plain;
        }

        @Override
        public void run() {
            PlainPinHandler.this.listener.onPlainPin(this.plain);
        }

        public String toString() {
            return "PlainRunner{plain=" + this.plain + '}';
        }
    }

    private class KeyPressRunner
    implements Runnable {
        private final int key;

        public KeyPressRunner(int key) {
            this.key = key;
        }

        @Override
        public void run() {
            PlainPinHandler.this.listener.onPressSpec(this.key);
        }

        public String toString() {
            return "KeyPressRunner{key=" + this.key + '}';
        }
    }

    private class ErrorRunner
    implements Runnable {
        private final int error;

        public ErrorRunner(int error) {
            this.error = error;
        }

        @Override
        public void run() {
            PlainPinHandler.this.listener.onError(this.error);
        }

        public String toString() {
            return "ErrorRunner{error=" + this.error + '}';
        }
    }
}

