/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.epp.stubconsole.driver;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import org.apache.log4j.Logger;
import ru.softlogic.crypto.DesHelper;
import ru.softlogic.hardware.epp.stub.driver.handler.Handler;
import ru.softlogic.hardware.epp.stubconsole.driver.handler.KeyPressHandler;
import ru.softlogic.hardware.epp.stubconsole.driver.handler.PinblockHandler;
import ru.softlogic.hardware.epp.stubconsole.driver.handler.PlainPinHandler;
import ru.softlogic.hdw.DeviceId;
import ru.softlogic.hdw.dev.epp.CryptoApi;
import ru.softlogic.hdw.dev.epp.CryptoException;
import ru.softlogic.hdw.dev.epp.CryptoUtils;
import ru.softlogic.hdw.dev.epp.EncryptMode;
import ru.softlogic.hdw.dev.epp.EppOptions;
import ru.softlogic.hdw.dev.epp.EppState;
import ru.softlogic.hdw.dev.epp.KeyNotFoundException;
import ru.softlogic.hdw.dev.epp.KeyTag;
import ru.softlogic.hdw.dev.epp.MacMode;
import ru.softlogic.hdw.dev.epp.PinblockRequest;
import ru.softlogic.hdw.dev.epp.PlainPinRequest;
import ru.softlogic.hdw.dev.epp.ReleaseApi;
import ru.softlogic.hdw.dev.epp.UIDStore;
import ru.softlogic.hdw.dev.epp.impl.BaseCryptoApi;
import ru.softlogic.hdw.dev.epp.impl.BaseEpp;
import ru.softlogic.hdw.dev.epp.impl.BasePinBlockApi;
import ru.softlogic.hdw.handling.DeviceState;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.utils.PropertiesStorage;
import ru.softlogic.utils.PropertiesStorageImpl;
import ru.softlogic.utils.b;

public class Driver
extends BaseEpp {
    private static final String PIN_MASTER_KEY = "PMK";
    private static final String MAC_MASTER_KEY = "MMK";
    private static final String ENC_MASTER_KEY = "EMK";
    private static final String PIN_WORK_KEY = "PWK";
    private static final String MAC_WORK_KEY = "MAC";
    private static final String ENC_WORK_KEY = "EWK";
    private static final String DEFAULT_KEY = "";
    private EppOptions eppOptions;
    private Handler handler;
    private int lastDeviceMode = 0;
    private Thread modeRunner;
    PropertiesStorage stor;
    byte[] pinM = null;
    byte[] pinW = null;
    byte[] macM = null;
    byte[] macW = null;
    byte[] encM = null;
    byte[] encW = null;

    public Driver(SerialPort port, UIDStore store, EppOptions eppOptions, Logger log) throws Exception {
        super(new DeviceId(8, "stubconsole", 0), port, "1.0", log, store, eppOptions);
        if (eppOptions == null) {
            throw new NullPointerException("KeyModeOptions");
        }
        if (log == null) {
            throw new NullPointerException("Logger");
        }
        String filename = System.getProperty("epp.stub.keys.path");
        File propFile = new File(filename);
        try {
            this.stor = new PropertiesStorageImpl(propFile);
        }
        catch (IOException ex) {
            throw new NullPointerException("epp-stub-device prop file not found");
        }
        Properties p = this.stor.getProperties();
        this.pinM = b.convertFromHex((String)p.getProperty(PIN_MASTER_KEY, DEFAULT_KEY));
        this.pinW = b.convertFromHex((String)p.getProperty(PIN_WORK_KEY, DEFAULT_KEY));
        this.macM = b.convertFromHex((String)p.getProperty(MAC_MASTER_KEY, DEFAULT_KEY));
        this.macW = b.convertFromHex((String)p.getProperty(MAC_WORK_KEY, DEFAULT_KEY));
        this.encM = b.convertFromHex((String)p.getProperty(ENC_MASTER_KEY, DEFAULT_KEY));
        this.encW = b.convertFromHex((String)p.getProperty(ENC_WORK_KEY, DEFAULT_KEY));
        this.port = port;
        this.eppOptions = eppOptions;
        this.log = log;
        this.store = store;
    }

    public synchronized ReleaseApi selectPinBlockMode(PinblockRequest request) {
        this.log.info((Object)"Select pinblock mode");
        super.selectPinBlockMode(request);
        return new DriverPinBlockApi(this);
    }

    public synchronized CryptoApi selectCryptoMode() {
        this.log.info((Object)"Select crypto mode");
        super.selectCryptoMode();
        return new DriverCryptoApi(this);
    }

    public synchronized ReleaseApi selectPlainPinMode(PlainPinRequest opr) {
        this.log.info((Object)"Select open pin mode");
        super.selectPlainPinMode(opr);
        return new DriverPlainPinApi(this);
    }

    private void checkState() throws IOException {
        this.updateState((DeviceState)new EppState(0));
    }

    protected void _run() throws InterruptedException {
        this.log.info((Object)"Start thread");
        this.log.info((Object)("Thread ID: " + Thread.currentThread().getId()));
        this.log.info((Object)"Device type: CONSOLE");
        try {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    this.checkState();
                    this.sleep(200);
                }
                catch (IOException ex) {
                    this.changeState(0);
                    this.randomSleep(500, 500);
                }
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        this.log.info((Object)"Stop thread");
    }

    public byte[] getKcv(int i, KeyTag keyTag) throws KeyNotFoundException, IOException {
        try {
            byte[] work = null;
            block1 : switch (i) {
                case 2: {
                    switch (keyTag) {
                        case PinKey: {
                            work = this.pinW;
                            break;
                        }
                        case MacKey: {
                            work = this.macW;
                            break;
                        }
                        case EncryptKey: {
                            work = this.encW;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (keyTag) {
                        case PinKey: {
                            work = this.pinM;
                            break block1;
                        }
                        case MacKey: {
                            work = this.macM;
                            break block1;
                        }
                        case EncryptKey: {
                            work = this.encM;
                        }
                    }
                }
            }
            if (work != null && work.length > 0) {
                byte[] data = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
                byte[] res = work.length == 8 ? DesHelper.encryptEcb((byte[])CryptoUtils.zeroPadding((byte[])data, (int)8), (byte[])work) : DesHelper.encryptEdeEcb((byte[])CryptoUtils.zeroPadding((byte[])data, (int)8), (byte[])work);
                return Arrays.copyOfRange(res, 0, 3);
            }
            throw new KeyNotFoundException(keyTag.name());
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _changeMode(int mode) {
        Driver driver = this;
        synchronized (driver) {
            try {
                int currentMode = mode;
                if (this.lastDeviceMode != currentMode) {
                    this.lastDeviceMode = currentMode;
                    if (this.modeRunner != null && !this.modeRunner.isInterrupted()) {
                        this.modeRunner.interrupt();
                        this.modeRunner.join();
                    }
                    switch (currentMode) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            this.handler = new KeyPressHandler(this.bus, this.eppKeyListener, this.log, 60);
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 3: {
                            this.handler = new PinblockHandler(this.bus, this.pinW, this.pinblockRequest, this.eppOptions.getCompleteLength(), 60, this.log);
                            break;
                        }
                        case 4: {
                            this.handler = new PlainPinHandler(this.bus, this.plainPinRequest, this.eppOptions.getCompleteLength(), 60, this.log);
                            break;
                        }
                        default: {
                            this.log.error((Object)("Unknown mode: " + currentMode));
                        }
                    }
                    if (currentMode != 0 && currentMode != 2) {
                        this.log.info((Object)">> ");
                        this.log.info((Object)">> Handler created, process");
                        this.modeRunner = new Thread(this.handler);
                        this.modeRunner.start();
                    }
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public class DriverCryptoApi
    extends BaseCryptoApi {
        public DriverCryptoApi(BaseEpp epp) {
            super(epp);
        }

        public boolean isMacModeSupport(MacMode mm) {
            switch (mm) {
                case X9_9: 
                case X9_19: 
                case ISO_9797Alg1: {
                    return true;
                }
            }
            return false;
        }

        public byte[] mac(MacMode mode, byte[] data, int length) throws CryptoException {
            byte[] work = Driver.this.macW;
            try {
                switch (mode) {
                    case X9_9: {
                        return DesHelper.createAnsi99Mac((byte[])work, (byte[])data, (int)0, (int)data.length);
                    }
                    case X9_19: {
                        return DesHelper.createAnsi919Mac((byte[])work, (byte[])data);
                    }
                    case ISO_9797Alg1: {
                        if (work.length == 16) {
                            return DesHelper.createAnsi919MacAlg1((byte[])work, (byte[])data);
                        }
                        return DesHelper.createAnsi99Mac((byte[])work, (byte[])data, (int)0, (int)data.length);
                    }
                }
                throw new Exception("Unknown MAC:" + mode);
            }
            catch (Exception ex) {
                throw new CryptoException((Throwable)ex);
            }
        }

        public byte[] mac(byte[] data, int length) throws CryptoException {
            byte[] work = Driver.this.macW;
            try {
                if (work.length > 0) {
                    if (work.length == 16) {
                        return DesHelper.createAnsi919Mac((byte[])work, (byte[])data);
                    }
                    return DesHelper.createAnsi99Mac((byte[])work, (byte[])data, (int)0, (int)length);
                }
                throw new Exception("No MAC key");
            }
            catch (Exception ex) {
                throw new CryptoException((Throwable)ex);
            }
        }

        public byte[] encrypt(EncryptMode mode, byte[] data) throws CryptoException {
            byte[] work = Driver.this.encW;
            try {
                if (work.length > 0) {
                    if (work.length == 8) {
                        return DesHelper.encryptEcb((byte[])CryptoUtils.zeroPadding((byte[])data, (int)8), (byte[])work);
                    }
                    if (mode == EncryptMode.Cbc) {
                        return DesHelper.encryptEdeCBC((byte[])CryptoUtils.zeroPadding((byte[])data, (int)8), (byte[])work);
                    }
                    return DesHelper.encryptEdeEcb((byte[])CryptoUtils.zeroPadding((byte[])data, (int)8), (byte[])work);
                }
                throw new Exception("No EWK key");
            }
            catch (Exception ex) {
                throw new CryptoException((Throwable)ex);
            }
        }

        public byte[] decrypt(EncryptMode mode, byte[] data) throws CryptoException {
            byte[] work = Driver.this.encW;
            try {
                if (work.length > 0) {
                    if (work.length == 8) {
                        return DesHelper.decryptEcb((byte[])CryptoUtils.zeroPadding((byte[])data, (int)8), (byte[])work);
                    }
                    if (mode == EncryptMode.Cbc) {
                        return DesHelper.decryptEdeCBC((byte[])CryptoUtils.zeroPadding((byte[])data, (int)8), (byte[])work);
                    }
                    return DesHelper.decryptEdeEcb((byte[])CryptoUtils.zeroPadding((byte[])data, (int)8), (byte[])work);
                }
                throw new Exception("No EWK key");
            }
            catch (Exception ex) {
                throw new CryptoException((Throwable)ex);
            }
        }

        public void loadWorkKey(KeyTag keyTag, byte[] keyCryptogram) throws CryptoException {
            try {
                byte[] key;
                String masterName = null;
                String workName = null;
                switch (keyTag) {
                    case PinKey: {
                        masterName = Driver.PIN_MASTER_KEY;
                        workName = Driver.PIN_WORK_KEY;
                        break;
                    }
                    case MacKey: {
                        masterName = Driver.MAC_MASTER_KEY;
                        workName = Driver.MAC_WORK_KEY;
                        break;
                    }
                    case EncryptKey: {
                        masterName = Driver.ENC_MASTER_KEY;
                        workName = Driver.ENC_WORK_KEY;
                    }
                }
                byte[] master = b.convertFromHex((String)Driver.this.stor.getProperties().getProperty(masterName));
                byte[] work = key = DesHelper.decryptEdeEcb((byte[])keyCryptogram, (byte[])master);
                Driver.this.stor.getProperties().setProperty(workName + "Crypto", b.toHexString((byte[])keyCryptogram));
                Driver.this.stor.getProperties().setProperty(workName, b.toHexString((byte[])work));
                Driver.this.stor.store();
                switch (keyTag) {
                    case PinKey: {
                        Driver.this.pinW = key;
                        break;
                    }
                    case MacKey: {
                        Driver.this.macW = key;
                        break;
                    }
                    case EncryptKey: {
                        Driver.this.encW = key;
                    }
                }
            }
            catch (Exception e) {
                throw new CryptoException((Throwable)e);
            }
        }

        public void release() {
            Driver.this.log.info((Object)"Crypto mode is released");
            super.release();
        }

        private byte[] encrypt(EncryptMode mode, byte[] data, int encMode, KeyTag tag) throws CryptoException {
            if (mode == null) {
                throw new NullPointerException("Mode is not set");
            }
            if (data == null) {
                throw new NullPointerException("Data is not set");
            }
            return new byte[0];
        }
    }

    public class DriverPlainPinApi
    extends BasePinBlockApi {
        public DriverPlainPinApi(BaseEpp epp) {
            super(epp);
        }

        public void release() {
            Driver.this.log.info((Object)"Open pin mode is released");
            super.release();
        }
    }

    public class DriverPinBlockApi
    extends BasePinBlockApi {
        public DriverPinBlockApi(BaseEpp epp) {
            super(epp);
        }

        public void release() {
            Driver.this.log.info((Object)"Pinblock mode is released");
            super.release();
        }
    }
}

