/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.epp.stub.driver.handler;

import org.apache.log4j.Logger;
import ru.softlogic.crypto.DesHelper;
import ru.softlogic.hardware.epp.stub.driver.handler.BaseHandler;
import ru.softlogic.hardware.epp.stub.driver.handler.Handler;
import ru.softlogic.hardware.epp.stub.driver.handler.StubApp;
import ru.softlogic.hdw.TaskBus;
import ru.softlogic.hdw.dev.epp.EppPinblockListener;
import ru.softlogic.hdw.dev.epp.PinblockRequest;
import ru.softlogic.utils.b;

public class FXPinblockHandler
extends BaseHandler
implements Handler {
    private final TaskBus bus;
    private final PinblockRequest request;
    private final int comleteLen;
    private final Logger log;
    private final EppPinblockListener listener;
    private final byte[] pwk;
    private final StubApp stubApp;

    public FXPinblockHandler(TaskBus bus, byte[] pwk, PinblockRequest request, int comleteLen, int timeout, Logger log, StubApp stubApp) {
        super(timeout);
        this.bus = bus;
        this.request = request;
        this.comleteLen = comleteLen;
        this.log = log;
        this.listener = request.getListener();
        this.pwk = pwk;
        this.stubApp = stubApp;
    }

    private void notifyError(int error) {
        this.bus.addTask((Runnable)new ErrorRunner(error));
    }

    private void notifySpec(int key) {
        this.bus.addTask((Runnable)new KeyPressRunner(key));
    }

    private void notifyPinblock(byte[] pb) {
        this.bus.addTask((Runnable)new PinBlockRunner(pb));
    }

    private void onEnter(int inputcode) {
        String card_pan = this.request.getPan();
        String card_pin = Integer.toString(inputcode);
        byte[] pan = b.convertFromHex((String)("0000" + card_pan.substring(3, 15)));
        String pinBl = String.format("%02d%s", card_pin.length(), card_pin);
        StringBuilder sb = new StringBuilder(pinBl);
        for (int i = 16 - pinBl.length(); i > 0; --i) {
            sb.append('F');
        }
        pinBl = sb.toString();
        byte[] pin = b.convertFromHex((String)pinBl);
        byte[] block = b.xor((byte[])pin, (byte[])pan);
        try {
            if (this.pwk.length == 8) {
                this.notifyPinblock(DesHelper.encryptEcb((byte[])block, (byte[])this.pwk));
            } else {
                this.notifyPinblock(DesHelper.encryptEdeEcb((byte[])block, (byte[])this.pwk));
            }
        }
        catch (Exception ex) {
            this.log.error((Object)("error:" + ex.getMessage()), (Throwable)ex);
            this.notifyError(4);
        }
    }

    @Override
    public void run() {
        this.stubApp.showApp();
        this.stubApp.setListener(new StubApp.ButtonEvent(){
            char[] buf = new char[20];
            int len = 0;

            @Override
            public void onButton(String id) {
                switch (id) {
                    case "0": 
                    case "1": 
                    case "2": 
                    case "3": 
                    case "4": 
                    case "5": 
                    case "6": 
                    case "7": 
                    case "8": 
                    case "9": {
                        FXPinblockHandler.this.reset();
                        FXPinblockHandler.this.listener.onPressKey('*');
                        this.buf[this.len++] = id.charAt(0);
                        if (FXPinblockHandler.this.comleteLen <= 0 || this.len != FXPinblockHandler.this.comleteLen) break;
                        FXPinblockHandler.this.onEnter(Integer.parseInt(new String(this.buf, 0, this.len)));
                        FXPinblockHandler.this.finish();
                        break;
                    }
                    case "CORRECT": {
                        FXPinblockHandler.this.reset();
                        if (this.len > 0) {
                            --this.len;
                        }
                        FXPinblockHandler.this.notifySpec(2);
                        break;
                    }
                    case "CONFIRM": {
                        if (this.len > 0) {
                            FXPinblockHandler.this.onEnter(Integer.parseInt(new String(this.buf, 0, this.len)));
                        } else {
                            FXPinblockHandler.this.notifyError(2);
                        }
                        FXPinblockHandler.this.finish();
                        break;
                    }
                    case "CANCEL": {
                        FXPinblockHandler.this.notifyError(2);
                        FXPinblockHandler.this.finish();
                    }
                }
            }
        });
        this.log.info((Object)"Start pinblock handler");
        this.wait(new Runnable(){

            @Override
            public void run() {
                FXPinblockHandler.this.notifyError(1);
            }
        });
        this.log.info((Object)"Pinblock handler 'process' finish");
        this.stubApp.setListener(null);
        this.stubApp.hideApp();
    }

    private class PinBlockRunner
    implements Runnable {
        private final byte[] pinblock;

        public PinBlockRunner(byte[] pinblock) {
            this.pinblock = pinblock;
        }

        @Override
        public void run() {
            FXPinblockHandler.this.listener.onPinblock(this.pinblock);
        }

        public String toString() {
            return "PinBlockRunner{plain=" + this.pinblock + '}';
        }
    }

    private class KeyPressRunner
    implements Runnable {
        private final int key;

        public KeyPressRunner(int key) {
            this.key = key;
        }

        @Override
        public void run() {
            FXPinblockHandler.this.listener.onPressSpec(this.key);
        }

        public String toString() {
            return "KeyPressRunner{key=" + this.key + '}';
        }
    }

    private class ErrorRunner
    implements Runnable {
        private final int error;

        public ErrorRunner(int error) {
            this.error = error;
        }

        @Override
        public void run() {
            FXPinblockHandler.this.listener.onError(this.error);
        }

        public String toString() {
            return "ErrorRunner{error=" + this.error + '}';
        }
    }
}

