/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.epp.stub.driver.handler;

import org.apache.log4j.Logger;
import ru.softlogic.hardware.epp.stub.driver.handler.BaseHandler;
import ru.softlogic.hardware.epp.stub.driver.handler.Handler;
import ru.softlogic.hardware.epp.stub.driver.handler.StubApp;
import ru.softlogic.hdw.TaskBus;
import ru.softlogic.hdw.dev.epp.EppKeyListener;

public class FXKeyPressHandler
extends BaseHandler
implements Handler {
    private final EppKeyListener listener;
    private final TaskBus bus;
    private final Logger log;
    private final StubApp stubApp;

    public FXKeyPressHandler(TaskBus bus, EppKeyListener listener, Logger log, int timeout, StubApp stubApp) {
        super(timeout);
        this.bus = bus;
        this.listener = listener;
        this.log = log;
        this.stubApp = stubApp;
    }

    private void notifySpec(int key) {
        this.bus.addTask((Runnable)new KeyPressRunner(key));
    }

    @Override
    public void run() {
        this.stubApp.showApp();
        this.stubApp.setListener(new StubApp.ButtonEvent(){
            char[] buf = new char[20];
            int len = 0;

            @Override
            public void onButton(String id) {
                switch (id) {
                    case "0": 
                    case "1": 
                    case "2": 
                    case "3": 
                    case "4": 
                    case "5": 
                    case "6": 
                    case "7": 
                    case "8": 
                    case "9": {
                        FXKeyPressHandler.this.listener.onPressKey(id.charAt(0));
                        FXKeyPressHandler.this.reset();
                        break;
                    }
                    case "CORRECT": {
                        FXKeyPressHandler.this.notifySpec(2);
                        FXKeyPressHandler.this.reset();
                        break;
                    }
                    case "CONFIRM": {
                        FXKeyPressHandler.this.notifySpec(0);
                        FXKeyPressHandler.this.reset();
                        break;
                    }
                    case "CANCEL": {
                        FXKeyPressHandler.this.notifySpec(1);
                        FXKeyPressHandler.this.reset();
                        break;
                    }
                    case ".": {
                        FXKeyPressHandler.this.notifySpec(4);
                        FXKeyPressHandler.this.reset();
                        break;
                    }
                    case " ": {
                        FXKeyPressHandler.this.notifySpec(3);
                        FXKeyPressHandler.this.reset();
                        break;
                    }
                    case "00": {
                        FXKeyPressHandler.this.notifySpec(5);
                        FXKeyPressHandler.this.reset();
                    }
                }
            }
        });
        this.log.info((Object)"Start key press handler");
        this.log.info((Object)"Set open mode");
        this.wait(new Runnable(){

            @Override
            public void run() {
            }
        });
        this.log.info((Object)"Key press handler done");
        this.log.info((Object)"Key press 'process' finish");
        this.stubApp.setListener(null);
        this.stubApp.hideApp();
    }

    private class KeyPressRunner
    implements Runnable {
        private final int key;

        public KeyPressRunner(int key) {
            this.key = key;
        }

        @Override
        public void run() {
            FXKeyPressHandler.this.listener.onPressSpec(this.key);
        }

        public String toString() {
            return "KeyPressRunner{key=" + this.key + '}';
        }
    }
}

