/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.epp.stub.driver.handler;

import ru.softlogic.hardware.epp.stub.driver.handler.Handler;

public abstract class BaseHandler
implements Handler {
    private final int timeout;
    private boolean done;
    private int counter;
    private final Object lock = new Object();

    public BaseHandler(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public boolean isComplete() {
        return this.isDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDone() {
        Object object = this.lock;
        synchronized (object) {
            return this.done;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        Object object = this.lock;
        synchronized (object) {
            this.done = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            this.counter = this.timeout * 10;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wait(Runnable onTimeout) {
        this.reset();
        Object object = this.lock;
        synchronized (object) {
            this.done = false;
        }
        while (!Thread.currentThread().isInterrupted() || !this.isDone()) {
            if (this.timeout > 0) {
                object = this.lock;
                synchronized (object) {
                    --this.counter;
                    if (this.counter == 0) {
                        onTimeout.run();
                        break;
                    }
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
    }
}

