/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.crd.stub.driver;

import java.net.URL;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.apache.log4j.Logger;
import ru.softlogic.fxstub.FxStubApp;
import ru.softlogic.hardware.crd.stub.driver.CardInfo;
import ru.softlogic.hardware.crd.stub.driver.TrackReader;
import ru.softlogic.hdw.dev.crd.CRMsg;
import ru.softlogic.hdw.dev.crd.TrackErrorException;
import ru.softlogic.hdw.handling.DeviceState;
import ru.softlogic.hdw.handling.HdwMsg;

public class StubApp
extends FxStubApp {
    @FXML
    private Label lblDevState;
    @FXML
    private Label lblCardState;
    @FXML
    private Label lblFile;
    @FXML
    private Button btnInsert;
    @FXML
    private Button btnPickup;
    @FXML
    private TextField tfName;
    @FXML
    private TextField tfTrack1;
    @FXML
    private TextField tfTrack2;
    @FXML
    private TextField tfTrack3;
    @FXML
    private ComboBox cbSelector;
    private volatile int cardState;
    ObservableList<CardInfo> cards;
    private TrackChangeListener tcl;
    private final Object lock = new Object();
    private boolean update;
    private String xmlFile;

    @Override
    protected void createScene() throws Exception {
        Stage stage = new Stage();
        stage.setTitle("Cardreader stub");
        URL resource = this.getClass().getResource("stub_pane.fxml");
        FXMLLoader l = new FXMLLoader(resource);
        l.setController((Object)this);
        Pane pane = (Pane)l.load();
        Scene scene = new Scene((Parent)pane);
        stage.setScene(scene);
        stage.setAlwaysOnTop(true);
        stage.setX(0.0);
        stage.setY(0.0);
        stage.show();
        this.stageApp = stage;
    }

    public void initApp(String file) {
        this.xmlFile = file;
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    StubApp.this.createScene();
                }
                catch (Exception ex) {
                    Logger.getLogger(ru.softlogic.hardware.epp.stub.driver.handler.StubApp.class).error((Object)("Error createScene:" + ex.getMessage()), (Throwable)ex);
                    return;
                }
                StubApp.this.lblFile.setText(StubApp.this.xmlFile);
                StubApp.this.loadTrack();
                StubApp.this.cbSelector.setConverter((StringConverter)new StringConverter<CardInfo>(){

                    public String toString(CardInfo object) {
                        return object.getName();
                    }

                    public CardInfo fromString(String string) {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }
                });
                StubApp.this.tcl = new TrackChangeListener();
                StubApp.this.cbSelector.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<CardInfo>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void changed(ObservableValue<? extends CardInfo> observable, CardInfo oldValue, CardInfo newValue) {
                        Object object = StubApp.this.lock;
                        synchronized (object) {
                            StubApp.this.update = false;
                        }
                        StubApp.this.tfName.setText(newValue.getName());
                        StubApp.this.tfTrack1.setText(newValue.getTrack1());
                        StubApp.this.tfTrack2.setText(newValue.getTrack2());
                        StubApp.this.tfTrack3.setText(newValue.getTrack3());
                        object = StubApp.this.lock;
                        synchronized (object) {
                            StubApp.this.update = true;
                        }
                    }
                });
                StubApp.this.cbSelector.setItems(StubApp.this.cards);
                StubApp.this.cbSelector.getSelectionModel().select(StubApp.this.loadSelected());
                StubApp.this.tfName.textProperty().addListener((ChangeListener)StubApp.this.tcl);
                StubApp.this.tfTrack1.textProperty().addListener((ChangeListener)StubApp.this.tcl);
                StubApp.this.tfTrack2.textProperty().addListener((ChangeListener)StubApp.this.tcl);
                StubApp.this.tfTrack3.textProperty().addListener((ChangeListener)StubApp.this.tcl);
            }
        });
    }

    public void updateDevState(DeviceState devState) {
        final String state = HdwMsg.getState((DeviceState)devState);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                StubApp.this.lblDevState.setText(state);
            }
        });
    }

    public void updateCardState(final int cardState, final boolean enabled) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                StubApp.this.cardState = cardState;
                StubApp.this.lblCardState.setText(CRMsg.getCardState((int)cardState));
                if (cardState == 4) {
                    StubApp.this.btnPickup.setDisable(false);
                    StubApp.this.showApp();
                } else {
                    StubApp.this.btnPickup.setDisable(true);
                }
                if (cardState == 0 && enabled) {
                    StubApp.this.btnInsert.setDisable(false);
                    StubApp.this.showApp();
                } else {
                    StubApp.this.btnInsert.setDisable(true);
                }
            }
        });
    }

    private void loadTrack() {
        Callback<CardInfo, Observable[]> extractor = new Callback<CardInfo, Observable[]>(){

            public Observable[] call(CardInfo s) {
                return new Observable[]{s.getNameProperty()};
            }
        };
        this.cards = FXCollections.observableArrayList((Callback)extractor);
        List<CardInfo> l = TrackReader.readXML(this.xmlFile);
        this.cards.addAll(l);
    }

    private int loadSelected() {
        return TrackReader.readXMLSelected(this.xmlFile);
    }

    public String getTrack1() throws TrackErrorException {
        String track = this.tfTrack1.getText();
        if (track.isEmpty()) {
            throw new TrackErrorException("Read track#1 error");
        }
        return track;
    }

    public String getTrack2() throws TrackErrorException {
        String track = this.tfTrack2.getText();
        if (track.isEmpty()) {
            throw new TrackErrorException("Read track#2 error");
        }
        return track;
    }

    public String getTrack3() throws TrackErrorException {
        String track = this.tfTrack3.getText();
        if (track.isEmpty()) {
            throw new TrackErrorException("Read track#3 error");
        }
        return track;
    }

    @FXML
    public void onInsertClick() throws TrackErrorException {
        this.cardState = 2;
        this.hideApp();
    }

    @FXML
    public void onPickUpClick() throws TrackErrorException {
        this.cardState = 0;
        this.hideApp();
    }

    public int getCardState() {
        return this.cardState;
    }

    @FXML
    public void onAddClick() {
        CardInfo ci = new CardInfo("", "", "", "");
        this.cards.add((Object)ci);
        this.cbSelector.getSelectionModel().select((Object)ci);
    }

    @FXML
    public void onDelClick() {
        CardInfo it = (CardInfo)this.cbSelector.getSelectionModel().getSelectedItem();
        this.cbSelector.getSelectionModel().selectPrevious();
        this.cards.remove((Object)it);
    }

    @FXML
    public void onSaveClick() {
        TrackReader.saveToXML(this.xmlFile, this.cards, this.cbSelector.getSelectionModel().getSelectedIndex());
    }

    class TrackChangeListener
    implements ChangeListener<String> {
        TrackChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
            Object object = StubApp.this.lock;
            synchronized (object) {
                CardInfo item;
                if (StubApp.this.update && (item = (CardInfo)StubApp.this.cbSelector.getSelectionModel().getSelectedItem()) != null) {
                    item.setName(StubApp.this.tfName.getText());
                    item.setTrack1(StubApp.this.tfTrack1.getText());
                    item.setTrack2(StubApp.this.tfTrack2.getText());
                    item.setTrack3(StubApp.this.tfTrack3.getText());
                    StubApp.this.cbSelector.setPromptText(item.getName());
                }
            }
        }
    }
}

