/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.crd.stub.driver;

import java.util.Objects;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.crd.stub.driver.StubApp;
import ru.softlogic.hdw.DeviceId;
import ru.softlogic.hdw.dev.crd.BaseMagneticApi;
import ru.softlogic.hdw.dev.crd.CRMsg;
import ru.softlogic.hdw.dev.crd.CardReaderException;
import ru.softlogic.hdw.dev.crd.CardReaderOptions;
import ru.softlogic.hdw.dev.crd.Description;
import ru.softlogic.hdw.dev.crd.IcApi;
import ru.softlogic.hdw.dev.crd.TrackErrorException;
import ru.softlogic.hdw.dev.crd.impl.MotorInsertionDriver;
import ru.softlogic.hdw.handling.DeviceState;
import ru.softlogic.io.serial.SerialPort;

public class Driver
extends MotorInsertionDriver {
    private final Description cardDescription;
    private int errorCode;
    private final StubApp stubApp;

    public Driver(SerialPort port, CardReaderOptions options, Logger l) {
        super(new DeviceId(7, "stub", 0), port, "2.0", l);
        this.log = Objects.requireNonNull(l, "Logger is not set");
        this.magneticApi = new MagneticStripeAPI();
        this.cardDescription = new Description(3);
        this.stubApp = new StubApp();
    }

    public Description getDescription() {
        return this.cardDescription;
    }

    public IcApi getIcApi() throws CardReaderException {
        return null;
    }

    public void captureCard() throws CardReaderException {
        try {
            super.captureCard();
            this.sleep(500);
            this.updateCardState(0);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    public void ejectCard() throws CardReaderException {
        try {
            this.sleep(500);
            if (this.currCardState != 2) {
                throw new IllegalStateException("The card can not be ejected from the " + CRMsg.getCardState((int)this.currCardState));
            }
            this.updateCardState(4);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    protected void _run() throws InterruptedException {
        try {
            this.log.info((Object)"Start thread");
            this.log.info((Object)("Thread ID: " + Thread.currentThread().getId()));
            this.log.info((Object)"Driver: Stub");
            this.updateState(new DeviceState(7, -4));
            String xmlFile = System.getProperty("crd.stub.tracks.path", "tracks.xml");
            while (!this.stubApp.isReady()) {
                this.log.debug((Object)"CRD stubApp.isReady(): false");
                try {
                    this.sleep(50);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
            this.stubApp.initApp(xmlFile);
            while (!this.stubApp.isInited()) {
                this.log.debug((Object)"CRD stubApp.isInited(): false");
                try {
                    this.sleep(50);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
            this.stubApp.hideApp();
            this.log.info((Object)"Cardreader stub app init");
            try {
                this.updateState(new DeviceState(7, 0));
                while (!Thread.currentThread().isInterrupted()) {
                    this.updateState(this.errorCode);
                    if (this.stubApp != null) {
                        this.sleep(10);
                        this.updateCardState(this.stubApp.getCardState());
                        this.stubApp.updateDevState(this.getLastState());
                    }
                    this.onConnSuccess();
                    this.sleep(500);
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            this.log.info((Object)"Stop thread");
        }
        catch (Exception ex) {
            this.log.error((Object)"Create stage error", (Throwable)ex);
        }
    }

    public void release() {
        super.release();
    }

    protected synchronized void updateCardState(int cardState) {
        super.updateCardState(cardState);
        if (this.stubApp != null) {
            this.stubApp.updateCardState(cardState, this.enabled);
        }
    }

    private class MagneticStripeAPI
    extends BaseMagneticApi {
        private MagneticStripeAPI() {
        }

        public String readTrack(int trackNo) throws CardReaderException, TrackErrorException {
            if (Driver.this.stubApp == null) {
                throw new CardReaderException();
            }
            switch (trackNo) {
                case 1: {
                    return Driver.this.stubApp.getTrack1();
                }
                case 2: {
                    return Driver.this.stubApp.getTrack2();
                }
                case 3: {
                    return Driver.this.stubApp.getTrack3();
                }
            }
            throw new TrackErrorException("Track not exist");
        }
    }
}

