/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.proto.essp;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Random;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.proto.essp.Crc16;
import ru.softlogic.hdw.proto.essp.TransportLayer;
import ru.softlogic.hdw.proto.essp.WrongSequenceException;
import ru.softlogic.io.serial.Flush;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.utils.BU;

public class SSPLayer
implements TransportLayer {
    private final SerialPort port;
    private final Crc16 crc16;
    private final Logger log;
    private int attemptsCount = 3;
    private int timeout = 500;
    private int attemptPause = 1500;
    private boolean seqFlag = true;
    private Random random;

    public SSPLayer(SerialPort port, Crc16 crc16, Logger log) {
        if (port == null) {
            throw new NullPointerException("SerialPort");
        }
        if (crc16 == null) {
            throw new NullPointerException("Crc16");
        }
        if (log == null) {
            throw new NullPointerException("Logger");
        }
        this.port = port;
        this.crc16 = crc16;
        this.log = log;
        this.random = new Random();
    }

    @Override
    public byte[] sendPacket(int cmd, byte[] data, int slaveId) throws WrongSequenceException, IOException {
        return this.sendPacket(cmd, data, slaveId, this.timeout);
    }

    @Override
    public byte[] sendPacket(int cmd, byte[] data, int slaveId, int timeout) throws WrongSequenceException, IOException {
        Exception last = null;
        this.port.setTimeout(timeout);
        this.seqFlag = !this.seqFlag;
        try {
            for (int i = 0; i < this.attemptsCount; ++i) {
                try {
                    this.port.flush(Flush.RxTx);
                    byte[] req = this.createTrasportPacket(cmd, data, slaveId, this.seqFlag);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)(">>" + BU.toString((byte[])req)));
                    }
                    this.port.write(req);
                    for (int j = 0; j < 100; ++j) {
                        int bt = this.port.readByte();
                        if (bt == 127) {
                            this.log.debug((Object)"start byte found");
                            byte[] hdr = this.port.read(2);
                            this.log.debug((Object)("<<header: " + BU.toString((byte[])hdr)));
                            int lenOth = hdr[1] + 2;
                            LinkedList<Byte> oth1 = new LinkedList<Byte>();
                            while (oth1.size() < lenOth) {
                                int nb = this.port.readByte();
                                if (nb == 127) {
                                    int nbb = this.port.readByte();
                                    if (nbb != 127) {
                                        this.log.warn((Object)("Wrong sequence 7F " + String.format("%02X", nbb)));
                                    }
                                    oth1.add((byte)127);
                                    continue;
                                }
                                oth1.add((byte)nb);
                            }
                            this.log.debug((Object)("<<readed: " + BU.toString(oth1)));
                            byte[] oth = BU.convert(oth1);
                            byte[] response = new byte[3 + lenOth];
                            response[0] = 127;
                            System.arraycopy(hdr, 0, response, 1, hdr.length);
                            System.arraycopy(oth, 0, response, 3, oth.length);
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)("<<" + BU.toString((byte[])response)));
                            }
                            if (!this.crc16.checkCrc16(response, 1)) {
                                throw new IOException("Crc is't correct: " + BU.toString((byte[])response));
                            }
                            if (Arrays.equals(response, req)) {
                                throw new Exception("Echo detected");
                            }
                            byte[] result = new byte[response.length - 5];
                            System.arraycopy(response, 3, result, 0, result.length);
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)("<|" + BU.toString((byte[])result)));
                            }
                            return result;
                        }
                        this.log.debug((Object)("unknown byte: " + String.format("0x%02x", bt)));
                    }
                    continue;
                }
                catch (IOException ex) {
                    Thread.sleep(this.random.nextInt(this.attemptPause));
                    this.port.close();
                    this.port.open();
                    this.port.flush(Flush.RxTx);
                    this.log.debug((Object)"Erron on process packet", (Throwable)ex);
                    last = ex;
                }
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (Exception ex) {
            last = ex;
        }
        throw new IOException("Send failed with " + this.attemptsCount + " attempts", last);
    }

    private byte[] createTrasportPacket(int cmd, byte[] data, int slaveId, boolean retransmission) {
        byte[] result = new byte[6 + (data == null ? 0 : data.length)];
        result[0] = 127;
        result[1] = (byte)slaveId;
        if (retransmission) {
            result[1] = (byte)(result[1] | 0x80);
        }
        result[2] = (byte)(result.length - 5);
        result[3] = (byte)cmd;
        if (data != null) {
            System.arraycopy(data, 0, result, 4, data.length);
        }
        int crc = this.crc16.makeCrc16(result, 1);
        result[result.length - 2] = (byte)(crc & 0xFF);
        result[result.length - 1] = (byte)(crc >> 8 & 0xFF);
        return this.pack(result);
    }

    private byte[] pack(byte[] data) {
        this.log.debug((Object)(">>" + BU.toString((byte[])data) + "(unpacked)"));
        LinkedList<Byte> packed = new LinkedList<Byte>();
        packed.add(data[0]);
        for (int i = 1; i < data.length; ++i) {
            if ((data[i] & 0xFF) == 127) {
                packed.add((byte)127);
                packed.add((byte)127);
                continue;
            }
            packed.add(data[i]);
        }
        this.log.debug((Object)(">>" + BU.toString(packed) + "(packed)"));
        return BU.convert(packed);
    }

    public void setAttempts(int attemptsCount) {
        this.attemptsCount = attemptsCount;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setAttemptPause(int attemptPause) {
        this.attemptPause = attemptPause;
    }

    public void resetSeqFlag() {
        this.seqFlag = false;
    }
}

