/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.proto.essp;

import java.io.IOException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.proto.essp.Banknote;
import ru.softlogic.hdw.proto.essp.CashBoxPayout;
import ru.softlogic.hdw.proto.essp.Consts;
import ru.softlogic.hdw.proto.essp.Counters;
import ru.softlogic.hdw.proto.essp.Crc16;
import ru.softlogic.hdw.proto.essp.HopperSetup;
import ru.softlogic.hdw.proto.essp.Result;
import ru.softlogic.hdw.proto.essp.SSPException;
import ru.softlogic.hdw.proto.essp.SSPLayer;
import ru.softlogic.hdw.proto.essp.SSPUtils;
import ru.softlogic.hdw.proto.essp.UnitData;
import ru.softlogic.hdw.proto.essp.ValidatorSetup;
import ru.softlogic.hdw.proto.essp.WrongSequenceException;
import ru.softlogic.hdw.proto.essp.eSSPException;
import ru.softlogic.hdw.proto.essp.eSSPLayer;
import ru.softlogic.hdw.proto.essp.m;
import ru.softlogic.io.serial.Flow;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.utils.BU;

public class SSPApi
extends Consts {
    public static final byte[] ITL_KEY = new byte[]{1, 35, 69, 103, 1, 35, 69, 103};
    private SerialPort port;
    private int slaveId;
    private Crc16 crc16;
    private SSPLayer tl;
    private eSSPLayer etl;
    private Logger log;

    public SSPApi(SerialPort port, int slaveId, Logger log) {
        if (port == null) {
            throw new NullPointerException("SerialPort");
        }
        if (log == null) {
            throw new NullPointerException("Logger");
        }
        this.port = port;
        this.slaveId = slaveId;
        this.log = log;
        this.crc16 = new Crc16();
        this.tl = new SSPLayer(port, this.crc16, log);
    }

    public int setHostProtocol(int protocol) throws WrongSequenceException, IOException {
        byte[] response = this.tl.sendPacket(6, new byte[]{(byte)protocol}, this.slaveId);
        int result = SSPUtils.getError(response);
        return result;
    }

    public void createEncryptedLayer(byte[] vendorKey) throws IOException, eSSPException, SSPException {
        if (vendorKey == null) {
            throw new NullPointerException("vendor key");
        }
        if (vendorKey.length != 8) {
            throw new IllegalArgumentException("key must be 8 byte length");
        }
        this.log.debug((Object)"init crypto layer");
        Random rnd = new Random();
        BigInteger gen = BigInteger.probablePrime(31, rnd);
        BigInteger mod = BigInteger.probablePrime(31, rnd);
        BigInteger exp = BigInteger.probablePrime(31, rnd);
        BigInteger numA = gen.modPow(exp, mod);
        this.checkResult(this.setGenerator(gen.intValue()));
        this.checkResult(this.setModulus(mod.intValue()));
        Result<byte[]> res = this.requestKeyExchange(numA.intValue());
        this.checkResult(res.getError());
        if (res.getData() == null || res.getData().length == 0) {
            throw new IOException("Device key not received");
        }
        if (res.getData().length != 8) {
            throw new IOException("Device key must be 64 bits lenght");
        }
        this.log.debug((Object)("b=" + BU.toString((byte[])res.getData())));
        BigInteger numB = new BigInteger(res.getData());
        BigInteger commonKey = numB.modPow(exp, mod);
        this.log.debug((Object)("secret key=" + commonKey));
        byte[] key = commonKey.toByteArray();
        byte[] key16 = new byte[16];
        System.arraycopy(key, 0, key16, 4, key.length);
        System.arraycopy(vendorKey, 0, key16, 8, vendorKey.length);
        this.log.debug((Object)("finalkey=" + BU.toString((byte[])key16)));
        this.etl = new eSSPLayer(this.tl, key16, this.crc16, this.log);
    }

    public int getSerial() throws IOException, SSPException {
        byte[] res = this.tl.sendPacket(12, null, this.slaveId);
        int error = SSPUtils.getError(res);
        if (error == 240) {
            int val = BU.cibe((byte[])res, (int)1);
            if (val < 0) {
                this.log.info((Object)("Serial answer: " + BU.toString((byte[])res)));
            }
            return val;
        }
        throw new SSPException(error);
    }

    public int reset() throws IOException {
        byte[] res = this.tl.sendPacket(1, null, this.slaveId, 50000);
        return SSPUtils.getError(res);
    }

    public void rejectBanknote() throws IOException, SSPException {
        byte[] res = this.tl.sendPacket(8, null, this.slaveId);
        SSPApi.checkResult(res);
    }

    public int sync() throws WrongSequenceException, IOException {
        byte[] res = this.tl.sendPacket(17, null, this.slaveId);
        return SSPUtils.getError(res);
    }

    public int enable() throws IOException {
        byte[] res = this.tl.sendPacket(10, null, this.slaveId);
        return SSPUtils.getError(res);
    }

    public int disable() throws IOException {
        byte[] res = this.tl.sendPacket(9, null, this.slaveId);
        return SSPUtils.getError(res);
    }

    public byte[] poll() throws IOException, SSPException {
        byte[] res = this.tl.sendPacket(7, null, this.slaveId);
        int error = SSPUtils.getError(res);
        if (error == 240) {
            byte[] data = new byte[res.length - 1];
            System.arraycopy(res, 1, data, 0, data.length);
            return data;
        }
        throw new SSPException(error);
    }

    public int getLastRejectCode() throws IOException, SSPException {
        byte[] res = this.tl.sendPacket(23, null, this.slaveId);
        int error = SSPUtils.getError(res);
        if (error == 240) {
            return BU.c((byte)res[1]);
        }
        throw new SSPException(error);
    }

    public UnitData getUnitData() throws IOException, SSPException {
        byte[] res = this.tl.sendPacket(13, null, this.slaveId);
        SSPApi.checkResult(res);
        return new UnitData(res[1], new String(res, 2, 2) + "." + new String(res, 4, 2), new String(res, 6, 3), BU.c((byte)res[11]), res[12]);
    }

    public HopperSetup getHopperSetup() throws IOException, SSPException {
        byte[] res = this.tl.sendPacket(5, null, this.slaveId);
        int error = SSPUtils.getError(res);
        if (error == 240) {
            byte unitType = res[1];
            if (unitType != 3) {
                throw new IOException("Wrong device type: " + unitType + ", must be 3(SMART Hopper)");
            }
            String firmvare = new String(res, 2, 2) + "." + new String(res, 4, 2);
            String countyCode = new String(res, 6, 3);
            byte protocol = res[9];
            int count = res[10];
            Banknote[] descs = new Banknote[count];
            if (protocol < 6) {
                for (int i = 0; i < count; ++i) {
                    descs[i] = new Banknote(SSPUtils.byteToInt(res, 11 + i * 2, 2), "");
                }
            } else {
                for (int i = 0; i < count; ++i) {
                    descs[i] = new Banknote(SSPUtils.byteToInt(res, 11 + i * 2, 2), new String(res, 11 + 2 * count + 3 * i, 3));
                }
            }
            return new HopperSetup(unitType, firmvare, countyCode, protocol, descs);
        }
        throw new SSPException(error);
    }

    public void setCoinMechInhibits(Banknote coin, boolean enable) throws IOException, SSPException {
        this.checkEncrypt();
        byte[] data = new byte[5 + coin.getCountry().length()];
        data[0] = (byte)(enable ? 1 : 0);
        SSPUtils.intToByte(coin.getNominal(), data, 1, 4);
        if (coin.getCountry() != null && !coin.getCountry().isEmpty()) {
            System.arraycopy(coin.getCountry().getBytes(), 0, data, 5, 3);
        }
        byte[] res = this.etl.sendPacket(64, data, this.slaveId);
        this.checkResult(SSPUtils.getError(res));
    }

    public int getMinimumPayout(String currency) throws IOException, SSPException {
        this.checkEncrypt();
        byte[] res = this.etl.sendPacket(62, currency != null ? currency.getBytes() : null, this.slaveId);
        SSPApi.checkResult(res);
        return SSPUtils.byteToInt(res, 1);
    }

    public void setCommandCalibration(int type) throws IOException, SSPException {
        this.checkEncrypt();
        if (type != 0 && type != 1) {
            throw new IllegalArgumentException("Unknown operation type");
        }
        byte[] res = this.etl.sendPacket(71, new byte[]{(byte)type}, this.slaveId);
        SSPApi.checkResult(res);
    }

    public void haltPayout() throws IOException, SSPException {
        this.checkEncrypt();
        SSPApi.checkResult(this.etl.sendPacket(56, null, this.slaveId));
    }

    public void setGlobalInhibit(boolean enabled) throws IOException, SSPException {
        byte[] res = this.etl.sendPacket(73, new byte[]{(byte)(enabled ? 1 : 0)}, this.slaveId);
        SSPApi.checkResult(res);
    }

    public int getOptions() throws IOException, SSPException {
        byte[] res = this.etl.sendPacket(81, null, this.slaveId);
        SSPApi.checkResult(res);
        return SSPUtils.byteToInt(res, 1);
    }

    public ValidatorSetup getValidatorSetup() throws IOException, SSPException {
        byte[] res = this.tl.sendPacket(5, null, this.slaveId);
        int error = SSPUtils.getError(res);
        if (error == 240) {
            int multiplier;
            byte unitType = res[1];
            if (unitType != 6 && unitType != 0) {
                throw new IOException("Wrong device type: " + unitType + ", must be 6(SMART Payout)");
            }
            String firmvare = new String(res, 2, 2) + "." + new String(res, 4, 2);
            String countyCode = new String(res, 6, 3);
            int n = BU.c((byte)res[12]);
            int protocol = BU.c((byte)res[16 + 2 * n]);
            int[] secures = new int[n];
            for (int i = 0; i < n; ++i) {
                secures[i] = BU.c((byte)res[13 + n + i]);
            }
            Banknote[] banknotes = new Banknote[n];
            if (protocol >= 6) {
                multiplier = BU.c((byte)res[15 + n * 2]);
                if (multiplier != 1 && multiplier != 10 && multiplier != 100) {
                    throw new IllegalArgumentException("Wrong multiplier value: " + multiplier);
                }
                for (int i = 0; i < n; ++i) {
                    banknotes[i] = new Banknote(SSPUtils.byteToInt(res, 17 + n * 5 + i * 4, 4) * multiplier, new String(res, 17 + n * 2 + i * 3, 3));
                }
            } else {
                multiplier = BU.c((byte)res[11]);
                if (multiplier != 1 && multiplier != 10 && multiplier != 100) {
                    throw new IllegalArgumentException("Wrong multiplier value: " + multiplier);
                }
                for (int i = 0; i < n; ++i) {
                    banknotes[i] = new Banknote(BU.c((byte)res[13 + i]) * multiplier, countyCode);
                }
            }
            return new ValidatorSetup(unitType, firmvare, countyCode, banknotes, secures, multiplier, protocol);
        }
        throw new SSPException(error);
    }

    public String getDataset() throws IOException, SSPException {
        byte[] res = this.tl.sendPacket(33, null, this.slaveId);
        SSPApi.checkResult(res);
        byte[] data = new byte[res.length - 1];
        System.arraycopy(res, 1, data, 0, data.length);
        return new String(data);
    }

    public String getFirmware() throws IOException, SSPException {
        byte[] res = this.tl.sendPacket(32, null, this.slaveId);
        SSPApi.checkResult(res);
        byte[] data = new byte[res.length - 1];
        System.arraycopy(res, 1, data, 0, data.length);
        return new String(data);
    }

    public int getUnitType() throws IOException, SSPException {
        byte[] res = this.tl.sendPacket(5, null, this.slaveId);
        this.log.debug((Object)BU.toString((byte[])res));
        int error = SSPUtils.getError(res);
        if (error == 240) {
            return BU.c((byte)res[1]);
        }
        throw new SSPException(error);
    }

    public int setChannelInhibits(int mask) throws IOException {
        byte[] res = this.tl.sendPacket(2, new byte[]{BU.c((int)mask)}, this.slaveId);
        return SSPUtils.getError(res);
    }

    public void enablePayoutDevice() throws IOException, SSPException {
        byte[] res = this.tl.sendPacket(92, null, this.slaveId);
        SSPApi.checkResult(res);
    }

    public int disablePayoutDevice() throws IOException {
        byte[] res = this.tl.sendPacket(91, null, this.slaveId);
        return SSPUtils.getError(res);
    }

    public void setRouting(int type, Banknote bn) throws IOException, SSPException {
        this.checkEncrypt();
        if (type != 0 && type != 1) {
            throw new IllegalArgumentException("Unknown operation type");
        }
        byte[] data = new byte[5 + (bn.getCountry() == null ? 0 : bn.getCountry().length())];
        data[0] = (byte)type;
        SSPUtils.intToByte4(bn.getNominal(), data, 1);
        if (bn.getCountry() != null && !bn.getCountry().isEmpty()) {
            System.arraycopy(bn.getCountry().getBytes(), 0, data, 5, 3);
        }
        byte[] res = this.etl.sendPacket(59, data, this.slaveId);
        SSPApi.checkResult(res);
    }

    public int getRouting(Banknote bn) throws IOException, SSPException {
        this.checkEncrypt();
        byte[] data = new byte[4 + bn.getCountry().length()];
        SSPUtils.intToByte4(bn.getNominal(), data, 0);
        if (bn.getCountry() != null) {
            System.arraycopy(bn.getCountry().getBytes(), 0, data, 4, 3);
        }
        byte[] res = this.etl.sendPacket(60, data, this.slaveId);
        SSPApi.checkResult(res);
        return BU.c((byte)res[1]);
    }

    public void open() throws IOException {
        this.port.open();
        this.tl.resetSeqFlag();
        this.port.setFlow(Flow.None);
        this.port.setRTS(false);
    }

    public void close() {
        this.port.close();
        this.etl = null;
    }

    private int setGenerator(int data) throws IOException {
        this.log.debug((Object)"set generator");
        return SSPUtils.getError(this.tl.sendPacket(74, SSPUtils.intToByte8(data), this.slaveId));
    }

    private int setModulus(int data) throws IOException {
        this.log.debug((Object)"set modulus");
        return SSPUtils.getError(this.tl.sendPacket(75, SSPUtils.intToByte8(data), this.slaveId));
    }

    private Result<byte[]> requestKeyExchange(int data) throws IOException {
        this.log.debug((Object)"request key exchange");
        byte[] response = this.tl.sendPacket(76, SSPUtils.intToByte8(data), this.slaveId);
        int error = SSPUtils.getError(response);
        if (error == 240) {
            byte[] dt = new byte[response.length - 1];
            for (int i = 0; i < 8; ++i) {
                dt[i] = response[8 - i];
            }
            return new Result<byte[]>(error, dt);
        }
        return new Result<byte[]>(error);
    }

    public void resetCounters() throws IOException, SSPException {
        byte[] response = this.tl.sendPacket(89, null, this.slaveId);
        SSPApi.checkResult(response);
    }

    public Counters getCounters() throws IOException, SSPException {
        byte[] response = this.tl.sendPacket(88, null, this.slaveId);
        SSPApi.checkResult(response);
        int count = BU.c((byte)response[1]);
        int stacked = count > 0 ? SSPUtils.byteToInt(response, 2, 4) : 0;
        int stored = count > 1 ? SSPUtils.byteToInt(response, 6, 4) : 0;
        int dispensed = count > 2 ? SSPUtils.byteToInt(response, 10, 4) : 0;
        int transferr = count > 3 ? SSPUtils.byteToInt(response, 14, 4) : 0;
        int rejected = count > 4 ? SSPUtils.byteToInt(response, 18, 4) : 0;
        return new Counters(stacked, stored, dispensed, transferr, rejected);
    }

    public void smartEmpty() throws IOException, SSPException {
        this.checkEncrypt();
        byte[] res = this.etl.sendPacket(82, null, this.slaveId);
        SSPApi.checkResult(res);
    }

    public CashBoxPayout cashboxPayoutData() throws IOException, SSPException {
        byte[] res = this.tl.sendPacket(83, null, this.slaveId);
        this.log.info((Object)("Result=" + BU.toString((byte[])res)));
        SSPApi.checkResult(res);
        return new CashBoxPayout(SSPUtils.convertToPayouts(res, 0), SSPUtils.byteToInt(res, res.length - 4, 4));
    }

    public void emptyAll() throws IOException, SSPException {
        byte[] res = this.etl.sendPacket(63, null, this.slaveId);
        SSPApi.checkResult(res);
    }

    public int getDenominationLevel(Banknote bn) throws IOException, SSPException {
        byte[] data = new byte[4 + bn.getCountry().length()];
        SSPUtils.intToByte4(bn.getNominal(), data, 0);
        if (bn.getCountry() != null) {
            System.arraycopy(bn.getCountry().getBytes(), 0, data, 4, 3);
        }
        byte[] res = this.etl.sendPacket(53, data, this.slaveId);
        SSPApi.checkResult(res);
        return BU.c((byte)res[1]) + BU.c((byte)res[2]) * 256;
    }

    public Map<Banknote, Integer> getAllLevels() throws IOException, SSPException {
        byte[] res = this.etl.sendPacket(34, null, this.slaveId);
        SSPApi.checkResult(res);
        HashMap<Banknote, Integer> set = new HashMap<Banknote, Integer>();
        for (int i = 0; i < BU.c((byte)res[1]); ++i) {
            int cnt = SSPUtils.byteToInt(res, 2 + i * 9, 2);
            Banknote bn = SSPUtils.convertToCoin(res, 3 + i * 9);
            if (cnt <= 0) continue;
            set.put(bn, cnt);
        }
        return set;
    }

    public void payoutByDenomination(int type, Map<Banknote, Integer> payouts) throws IOException, SSPException {
        this.checkEncrypt();
        if (type != 25 && type != 88) {
            throw new IllegalArgumentException("Unknown operation type");
        }
        byte[] data = new byte[2 + payouts.size() * 9];
        data[0] = (byte)payouts.size();
        int i = 0;
        for (Map.Entry<Banknote, Integer> entry : payouts.entrySet()) {
            int cnt = entry.getValue();
            Banknote bn = entry.getKey();
            SSPUtils.intToByte(cnt, data, 1 + i * 9, 2);
            SSPUtils.intToByte(bn.getNominal(), data, 3 + i * 9, 4);
            System.arraycopy(bn.getCountry().getBytes(), 0, data, 7 + i * 9, 3);
            ++i;
        }
        data[data.length - 1] = (byte)type;
        byte[] res = this.etl.sendPacket(70, data, this.slaveId);
        if (res.length != 1) {
            throw new SSPException(BU.c((byte)res[0]), m.getPayoutCause(BU.c((byte)res[1])));
        }
        SSPApi.checkResult(res);
    }

    public void payoutAmount(int type, int sum, String currency) throws IOException, SSPException {
        byte[] res;
        if (type != 25 && type != 88) {
            throw new IllegalArgumentException("Unknown operation type");
        }
        byte[] data = new byte[4 + (currency == null ? 0 : currency.length() + 1)];
        SSPUtils.intToByte4(sum, data, 0);
        if (currency != null) {
            System.arraycopy(currency.getBytes(), 0, data, 4, 3);
            data[7] = (byte)type;
        }
        if ((res = this.etl.sendPacket(51, data, this.slaveId)).length != 1) {
            throw new SSPException(BU.c((byte)res[0]), m.getPayoutCause(BU.c((byte)res[1])));
        }
        SSPApi.checkResult(res);
    }

    public Result<Integer> floatPayout(int type, int total, Banknote minimum) throws IOException {
        if (type != 25 && type != 88) {
            throw new IllegalArgumentException("Unknown operation type");
        }
        byte[] data = new byte[7 + minimum.getCountry().length()];
        SSPUtils.intToByte4(total, data, 0);
        SSPUtils.intToByte4(minimum.getNominal(), data, 2);
        if (minimum.getCountry() != null) {
            System.arraycopy(minimum.getCountry().getBytes(), 0, data, 6, 3);
            data[9] = (byte)type;
        }
        byte[] res = this.etl.sendPacket(61, data, this.slaveId);
        return this.getResult(res);
    }

    public Result<Integer> floatByDenomination(int type, Map<Banknote, Integer> payouts) throws IOException {
        if (type != 25 && type != 88) {
            throw new IllegalArgumentException("Unknown operation type");
        }
        byte[] data = new byte[2 + payouts.size() * 9];
        data[0] = BU.c((int)payouts.size());
        int i = 0;
        for (Map.Entry<Banknote, Integer> entry : payouts.entrySet()) {
            int cnt = entry.getValue();
            Banknote bn = entry.getKey();
            SSPUtils.intToByte(cnt, data, 1 + i * 9, 2);
            SSPUtils.intToByte(bn.getNominal(), data, 3 + i * 9, 4);
            System.arraycopy(bn.getCountry().getBytes(), 0, data, 7 + i * 9, 3);
            ++i;
        }
        data[data.length - 1] = BU.c((int)type);
        byte[] res = this.etl.sendPacket(68, data, this.slaveId);
        return this.getResult(res);
    }

    public int setOptions(int mask) throws IOException {
        byte[] data = new byte[2];
        SSPUtils.intToByte(mask, data, 0, 2);
        byte[] res = this.tl.sendPacket(80, data, this.slaveId);
        return SSPUtils.getError(res);
    }

    public void eventAsk() throws IOException, SSPException {
        this.checkEncrypt();
        byte[] res = this.etl.sendPacket(87, null, this.slaveId);
        SSPApi.checkResult(res);
    }

    public void setDenominationLevel(Banknote coin, int count) throws IOException, SSPException {
        if (count <= 0) {
            throw new IllegalArgumentException("Count must be positive");
        }
        this.checkEncrypt();
        byte[] data = new byte[6 + coin.getCountry().length()];
        SSPUtils.intToByte(count, data, 0, 2);
        SSPUtils.intToByte(coin.getNominal(), data, 2, 4);
        if (coin.getCountry() != null && !coin.getCountry().isEmpty()) {
            System.arraycopy(coin.getCountry().getBytes(), 0, data, 6, 3);
        }
        byte[] res = this.etl.sendPacket(52, data, this.slaveId);
        SSPApi.checkResult(res);
    }

    public void resetDenominationLevel(Banknote coin) throws IOException, SSPException {
        this.checkEncrypt();
        byte[] data = new byte[6 + coin.getCountry().length()];
        SSPUtils.intToByte(0, data, 0, 2);
        SSPUtils.intToByte(coin.getNominal(), data, 2, 4);
        if (coin.getCountry() != null && !coin.getCountry().isEmpty()) {
            System.arraycopy(coin.getCountry().getBytes(), 0, data, 6, 3);
        }
        byte[] res = this.etl.sendPacket(52, data, this.slaveId);
        SSPApi.checkResult(res);
    }

    public SSPLayer getConnector() {
        return this.tl;
    }

    private void checkResult(int result) throws SSPException {
        if (result != 240) {
            throw new SSPException(result, m.get(result));
        }
    }

    private void checkEncrypt() {
        if (this.etl == null) {
            throw new IllegalStateException("Requires encrypted mode");
        }
    }

    public static byte[] convertToCoin(Banknote banknote) {
        byte[] res = new byte[7];
        BU.sibe((byte[])res, (int)0, (int)banknote.getNominal());
        System.arraycopy(banknote.getCountry().getBytes(), 0, res, 4, 3);
        return res;
    }

    public static void checkResult(byte[] answer) throws SSPException {
        int code = BU.c((byte)answer[0]);
        if (code != 240) {
            throw new SSPException(code, m.get(code));
        }
    }

    private Result<Integer> getResult(byte[] res) {
        if (res.length > 1) {
            return new Result<Integer>(BU.c((byte)res[0]), BU.c((byte)res[1]));
        }
        return new Result<Integer>(BU.c((byte)res[0]));
    }
}

