/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.proto.cctalk.cdm;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.proto.cctalk.CoreApi;
import ru.softlogic.hdw.proto.cctalk.cdm.HopperApi;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.utils.BU;

public class PayoutApi
extends CoreApi {
    private Map<Integer, HopperApi> hApis;

    public PayoutApi(SerialPort port, Logger log) {
        this(port, 3, log);
    }

    public PayoutApi(SerialPort port, int dest, Logger log) {
        super(port, dest, log);
        port.setTimeout(2000);
        this.hApis = new HashMap<Integer, HopperApi>();
    }

    public HopperApi getHopperApi(int address) {
        HopperApi ha = this.hApis.get(address);
        if (ha == null) {
            ha = new HopperApi(this.conn, address, this.log);
            this.hApis.put(address, ha);
        }
        return ha;
    }

    public int requestAbsoluteCount(int hopperNo) throws IOException {
        byte[] data = this.conn.sendMessage(207, this.conv(hopperNo));
        return BU.c((byte)data[0]);
    }

    public int requestCapacity(int hopperNo) throws IOException {
        byte[] data = this.conn.sendMessage(186, this.conv(hopperNo));
        return BU.c((byte)data[0]);
    }

    public int requestFloat(int hopperNo) throws IOException {
        byte[] data = this.conn.sendMessage(174, this.conv(hopperNo));
        return BU.c((byte)data[0]);
    }

    public String requestHopperCoin() throws IOException {
        byte[] data = this.conn.sendMessage(171);
        return new String(data);
    }

    public int requestHopperDispenseCount() throws IOException {
        byte[] data = this.conn.sendMessage(168);
        return BU.c((byte)data[0]) + (BU.c((byte)data[1]) >> 8) + (BU.c((byte)data[2]) >> 16);
    }

    public String requestCoinHopperValue(int position) throws IOException {
        byte[] data = this.conn.sendMessage(131, new byte[]{(byte)(position & 0xFF)});
        try {
            String res = new String(data);
            if ("......".equals(res)) {
                return null;
            }
            return res;
        }
        catch (Exception ex) {
            return null;
        }
    }
}

