/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.proto.cctalk.cdm;

import java.io.IOException;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.proto.cctalk.Connection;
import ru.softlogic.hdw.proto.cctalk.cdm.HiLoStatus;
import ru.softlogic.hdw.proto.cctalk.cdm.HopperStatus;
import ru.softlogic.hdw.proto.cctalk.cdm.VariableSet;
import ru.softlogic.io.utils.BU;

public class HopperApi {
    private final Connection conn;
    private final int hopperId;
    private final Logger log;

    public HopperApi(Connection conn, int hopperId, Logger log) {
        if (conn == null) {
            throw new NullPointerException("Connection");
        }
        if (hopperId < 3 || hopperId > 9) {
            throw new NullPointerException("HopperId must be in range 3..9");
        }
        if (log == null) {
            throw new NullPointerException("Logger");
        }
        this.conn = conn;
        this.hopperId = hopperId;
        this.log = log;
    }

    public HopperStatus requestHopperStatus() throws IOException {
        byte[] data = this.conn.sendMessage(166, null, false, this.hopperId, null);
        return new HopperStatus(BU.c((byte)data[0]), BU.c((byte)data[1]), BU.c((byte)data[2]), BU.c((byte)data[3]));
    }

    public int dispenseHopperCoins(byte[] key, int count) throws IOException {
        if (key == null || key.length != 8) {
            throw new IllegalArgumentException("Key");
        }
        byte[] fd = new byte[9];
        for (int i = 0; i < 8; ++i) {
            fd[i] = BU.c((int)(255 - BU.c((byte)key[i])));
        }
        fd[8] = BU.c((int)count);
        byte[] data = this.conn.sendMessage(167, fd, false, this.hopperId, null);
        return BU.c((byte)data[0]);
    }

    public int dispenseHopperCoinsCubeMk2(byte[] key, int count) throws IOException {
        if (key.length != 3) {
            throw new IllegalArgumentException("Key");
        }
        byte[] fd = new byte[4];
        System.arraycopy(key, 0, fd, 0, key.length);
        fd[3] = BU.c((int)count);
        byte[] data = this.conn.sendMessage(167, fd, false, this.hopperId, null);
        return BU.c((byte)data[0]);
    }

    public byte[] requestCipherKey() throws IOException {
        return this.conn.sendMessage(160, null, false, this.hopperId, null);
    }

    public VariableSet requestVariableSet() throws IOException {
        byte[] data = this.conn.sendMessage(247, null, false, this.hopperId, null);
        return new VariableSet(BU.c((byte)data[0]), BU.c((byte)data[1]), BU.c((byte)data[2]), BU.c((byte)data[3]), BU.c((byte)data[4]), BU.c((byte)data[5]));
    }

    public void pumpRNG(byte[] data) throws IOException {
        if (data == null || data.length != 8) {
            throw new IllegalArgumentException("Data must be 8 bytes");
        }
        this.conn.sendMessage(161, data, false, this.hopperId, null);
    }

    public HiLoStatus requestHighLowStatus() throws IOException {
        byte[] data = this.conn.sendMessage(217, null, false, this.hopperId, null);
        return new HiLoStatus((data[0] & 1) > 0, (data[0] & 2) > 0, (data[0] & 0x10) > 0, (data[0] & 0x20) > 0);
    }

    public void resetDevice() throws IOException {
        this.conn.sendMessage(1, null, false, this.hopperId, null);
    }

    public void modifyVarialbeSet(int currentLimit, int motorStopDelay, int payoutTimeout, boolean singleCoinMode) throws IOException {
        this.conn.sendMessage(165, new byte[]{BU.c((int)currentLimit), BU.c((int)motorStopDelay), BU.c((int)payoutTimeout), BU.c((int)(singleCoinMode ? 1 : 0))}, false, this.hopperId, null);
    }

    public int emergencyStop() throws IOException {
        byte[] data = this.conn.sendMessage(172, null, false, this.hopperId, null);
        return BU.c((byte)data[0]);
    }

    public byte[] testHopper() throws IOException {
        return this.conn.sendMessage(163);
    }

    public void enableHopper(boolean enable) throws IOException {
        this.conn.sendMessage(164, new byte[]{enable ? (byte)-91 : 0}, false, this.hopperId, null);
    }

    public void printHopperRegisters(byte[] regs) {
        if (regs == null || regs.length != 2) {
            return;
        }
        int r = BU.c((byte)regs[0]);
        this.log.info((Object)("Register 0: " + BU.toHex((byte)regs[0])));
        if ((r & 1) != 0) {
            this.log.info((Object)"    Absolute maximum current exceeded");
        }
        if ((r & 2) != 0) {
            this.log.info((Object)"    Payout timeout occurred");
        }
        if ((r & 4) != 0) {
            this.log.info((Object)"    Motor reversed during last payout to clear a jam ");
        }
        if ((r & 8) != 0) {
            this.log.info((Object)"    Opto fraud attempt, path blocked during idle");
        }
        if ((r & 0x10) != 0) {
            this.log.info((Object)"    Opto fraud attempt, short-circuit during idle");
        }
        if ((r & 0x20) != 0) {
            this.log.info((Object)"    Opto blocked permanently during payout");
        }
        if ((r & 0x40) != 0) {
            this.log.info((Object)"    Power-up detected");
        }
        if ((r & 0x80) != 0) {
            this.log.info((Object)"    Payout disabled");
        }
        this.log.info((Object)("Register 1: " + BU.toHex((byte)regs[1])));
        r = BU.c((byte)regs[1]);
        if ((r & 1) != 0) {
            this.log.info((Object)"    Opto fraud attempt, short-circuit during payout");
        }
        if ((r & 2) != 0) {
            this.log.info((Object)"    Single coin payout mode");
        }
        if ((r & 4) != 0) {
            this.log.info((Object)"    Checksum A error");
        }
        if ((r & 8) != 0) {
            this.log.info((Object)"    Checksum B error");
        }
        if ((r & 0x10) != 0) {
            this.log.info((Object)"    Checksum C error");
        }
        if ((r & 0x20) != 0) {
            this.log.info((Object)"    Checksum D error");
        }
        if ((r & 0x40) != 0) {
            this.log.info((Object)"    Power fail during NV Memory write");
        }
        if ((r & 0x80) != 0) {
            this.log.info((Object)"    PIN number mechanism enabled");
        }
        this.log.info((Object)"---");
    }

    public void printFullHopperRegisters(byte[] regs) {
        if (regs == null || regs.length != 2) {
            return;
        }
        int r = BU.c((byte)regs[0]);
        this.log.info((Object)"Register 0");
        this.log.info((Object)("  Absolute maximum current exceeded:                " + ((r & 1) != 0)));
        this.log.info((Object)("  Payout timeout occurred:                          " + ((r & 2) != 0)));
        this.log.info((Object)("  Motor reversed during last payout to clear a jam: " + ((r & 4) != 0)));
        this.log.info((Object)("  Opto fraud attempt, path blocked during idle:     " + ((r & 8) != 0)));
        this.log.info((Object)("  Opto fraud attempt, short-circuit during idle:    " + ((r & 0x10) != 0)));
        this.log.info((Object)("  Opto blocked permanently during payout:           " + ((r & 0x20) != 0)));
        this.log.info((Object)("  Power-up detected:                                " + ((r & 0x40) != 0)));
        this.log.info((Object)("  Payout disabled:                                  " + ((r & 0x80) != 0)));
        this.log.info((Object)"Register 1");
        r = BU.c((byte)regs[1]);
        this.log.info((Object)("  Opto fraud attempt, short-circuit during payout:  " + ((r & 1) != 0)));
        this.log.info((Object)("  Single coin payout mode:                          " + ((r & 2) != 0)));
        this.log.info((Object)("  Checksum A error:                                 " + ((r & 4) != 0)));
        this.log.info((Object)("  Checksum B error:                                 " + ((r & 8) != 0)));
        this.log.info((Object)("  Checksum C error:                                 " + ((r & 0x10) != 0)));
        this.log.info((Object)("  Checksum D error:                                 " + ((r & 0x20) != 0)));
        this.log.info((Object)("  Power fail during NV Memory write:                " + ((r & 0x40) != 0)));
        this.log.info((Object)("  PIN number mechanism enabled:                     " + ((r & 0x80) != 0)));
        this.log.info((Object)"---");
    }
}

