/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.proto.cctalk;

import java.io.IOException;
import java.util.Arrays;
import org.apache.log4j.Logger;
import ru.softlogic.io.serial.Flush;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.utils.BU;

public class Connection {
    private final SerialPort port;
    private final Logger log;
    private int dest;
    private int attemptCount = 3;
    private int defaultTimeout = 1000;

    public Connection(SerialPort port, int dest, Logger log) {
        if (port == null) {
            throw new NullPointerException("SerialPort is null");
        }
        if (log == null) {
            throw new NullPointerException("Logger is null");
        }
        this.port = port;
        this.dest = dest;
        this.log = log;
    }

    public void setParams(int attemptCount, int defaultTimeout) {
        this.attemptCount = attemptCount;
        this.defaultTimeout = defaultTimeout;
    }

    public void resetParams() {
        this.attemptCount = 3;
        this.defaultTimeout = 1000;
    }

    public byte[] sendMessage(int header) throws IOException {
        return this.sendMessage(header, null);
    }

    public byte[] sendMessage(int header, byte[] data) throws IOException {
        return this.sendMessage(header, data, false, null, null);
    }

    public byte[] sendMessage(int header, boolean checkSupport) throws IOException {
        return this.sendMessage(header, null, checkSupport, null, null);
    }

    public void setDestinationId(int dest) {
        this.dest = dest;
    }

    public byte[] sendSimpleMessage(int header) throws IOException {
        byte[] request = this.getRequest(1, 0, header, null);
        this.port.setTimeout(100);
        this.port.write(request);
        byte[] echo = this.port.read(request.length);
        if (!Arrays.equals(request, echo)) {
            throw new IOException("Wrong echo: " + BU.toString((byte[])echo));
        }
        return this.port.tryRead();
    }

    public byte[] sendMessage(int header, byte[] data, boolean checkSupport, Integer destId, Integer timeout) throws IOException {
        IOException last = null;
        int realDest = destId != null ? destId : this.dest;
        byte[] request = this.getRequest(1, realDest, header, data);
        for (int i = 0; i < this.attemptCount; ++i) {
            try {
                this.port.flush(Flush.RxTx);
                this.log.debug((Object)(">>" + BU.toString((byte[])request)));
                this.port.setTimeout(timeout == null ? this.defaultTimeout : timeout);
                this.port.write(request);
                int res = this.port.readByte();
                this.log.debug((Object)("<<" + BU.toHex((int)res)));
                if (res == realDest) {
                    this.log.debug((Object)("<<" + BU.toString((byte[])this.port.read(request.length - 1))));
                    try {
                        res = this.port.readByte();
                        this.log.debug((Object)("<<" + BU.toHex((int)res)));
                    }
                    catch (IOException ex) {
                        if (checkSupport) {
                            return null;
                        }
                        throw ex;
                    }
                }
                if (res != 1) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                    this.log.debug((Object)("<<" + BU.toString((byte[])this.port.tryRead())));
                    throw new IOException("Expected '1', obtained " + BU.toHex((int)res));
                }
                int packetSize = this.port.readByte();
                this.log.debug((Object)("packet size=" + packetSize));
                byte[] oth = this.port.read(3 + packetSize);
                if (oth[1] == 5) {
                    throw new IOException("NAK");
                }
                if (oth[1] == 6) {
                    throw new IOException("BUSY");
                }
                if (oth[1] != 0) {
                    throw new IOException("Header not equals 0. Value " + oth[1]);
                }
                byte[] responce = new byte[5 + packetSize];
                responce[0] = (byte)res;
                responce[1] = (byte)packetSize;
                System.arraycopy(oth, 0, responce, 2, oth.length);
                this.log.debug((Object)("<<" + BU.toString((byte[])responce)));
                byte crc = this.getCrc(responce);
                if (crc != responce[responce.length - 1]) {
                    throw new IOException("CRC is not valid");
                }
                byte[] result = new byte[packetSize];
                System.arraycopy(responce, 4, result, 0, packetSize);
                this.log.debug((Object)("<< data=" + BU.toString((byte[])result)));
                return result;
            }
            catch (IOException ex) {
                this.log.debug((Object)("IO error " + ex.getMessage()));
                last = ex;
                continue;
            }
        }
        throw new IOException("IO erron on " + this.attemptCount + " attempts", last);
    }

    private byte[] getRequest(int srcAddress, int destAddress, int header, byte[] data) {
        byte[] request = new byte[5 + (data == null ? 0 : data.length)];
        request[0] = (byte)destAddress;
        request[1] = (byte)(data == null ? 0 : data.length);
        request[2] = (byte)srcAddress;
        request[3] = (byte)header;
        if (data != null && data.length > 0) {
            System.arraycopy(data, 0, request, 4, data.length);
        }
        request[request.length - 1] = this.getCrc(request);
        return request;
    }

    private byte getCrc(byte[] data) {
        int crc = 0;
        for (int i = 0; i < data.length - 1; ++i) {
            crc = (byte)(crc + data[i]);
        }
        return (byte)(256 - crc);
    }
}

