/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.pos.ttp2000.search;

import java.io.IOException;
import ru.softlogic.hardware.lookup.DeviceDescription;
import ru.softlogic.hardware.pos.ttp2000.ZebraApi;
import ru.softlogic.hardware.pos.ttp2000.ZebraDeviceId;
import ru.softlogic.hardware.search.BaseSearchable;
import ru.softlogic.hardware.search.NotFoundException;
import ru.softlogic.hardware.search.UsbSearchable;
import ru.softlogic.io.BidirectionPort;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Flush;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;
import ru.softlogic.io.usb.UsbPort;

public class Searchable
extends BaseSearchable
implements UsbSearchable {
    protected DeviceDescription _search(SerialPort port) throws NotFoundException {
        try {
            port.open();
            port.flush(Flush.RxTx);
            DeviceDescription deviceDescription = this.getDescription((BidirectionPort)port);
            return deviceDescription;
        }
        catch (IOException ex) {
            throw new NotFoundException("Not found", (Throwable)ex);
        }
        finally {
            port.close();
        }
    }

    public DeviceDescription search(UsbPort port) throws NotFoundException {
        try {
            port.open();
            port.setTimeout(20);
            DeviceDescription deviceDescription = this.getDescription((BidirectionPort)port);
            return deviceDescription;
        }
        catch (IOException ex) {
            throw new NotFoundException("Not found", (Throwable)ex);
        }
        finally {
            port.close();
        }
    }

    private DeviceDescription getDescription(BidirectionPort port) throws IOException, NotFoundException {
        ZebraApi api = new ZebraApi(port);
        this.log.info((Object)("Firmware: " + api.getFirmware()));
        this.log.info((Object)("Serial: " + api.getSerialNumber()));
        ZebraDeviceId di = api.getDeviceId();
        this.log.info((Object)("Device ID: " + di));
        if (di.isTTP2000()) {
            return this.createDescriptor("pos", "ttp2000");
        }
        throw new NotFoundException("Not found: " + di);
    }

    public SerialParams[] getSearchParams(int priority) {
        if (priority == 0) {
            return new SerialParams[]{new SerialParams(9600, DataBits.Eight, StopBits.One, Parity.None)};
        }
        if (priority == 1) {
            return new SerialParams[]{new SerialParams(19200, DataBits.Eight, StopBits.One, Parity.None)};
        }
        if (priority == 2) {
            return new SerialParams[]{new SerialParams(38400, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(57600, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(115200, DataBits.Eight, StopBits.One, Parity.None)};
        }
        return NO_SERIAL_PARAMS;
    }

    public int getSearchOrder() {
        return 80;
    }

    public boolean canSearch(SerialPort port) {
        return this.canSearch(port, 1);
    }

    public String identity(SerialPort port) {
        return "n/a";
    }

    public UsbSearchable getUsbSearchable() {
        return this;
    }

    public String identity(UsbPort port) {
        return "n/a";
    }
}

