/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.pos.ttp2000;

import java.io.IOException;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.pos.StateExtractor;
import ru.softlogic.hdw.dev.printer.pos.PosPrinterState;
import ru.softlogic.io.BidirectionPort;

class ZebraStateExtractor
implements StateExtractor {
    private final BidirectionPort port;
    private final Logger log;

    public ZebraStateExtractor(BidirectionPort port, Logger log) {
        this.port = port;
        this.log = log;
    }

    @Override
    public PosPrinterState getState() throws IOException {
        int state;
        switch (this.getPrinterState()) {
            case 0: {
                state = 0;
                break;
            }
            case 3: {
                state = 1;
                break;
            }
            default: {
                state = -7;
            }
        }
        int flags = this.isPaperNearEnd() ? 1 : 0;
        return new PosPrinterState(state, flags);
    }

    private boolean isPaperNearEnd() throws IOException {
        this.port.write(new byte[]{27, 5, 2});
        int res = this.port.readByte();
        return res != 0;
    }

    private int getPrinterState() throws IOException {
        this.port.write(new byte[]{27, 5, 1});
        int res = this.port.readByte();
        if (res == 6) {
            return 0;
        }
        return this.port.readByte();
    }
}

