/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.pos.generic;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.pos.Cmd;
import ru.softlogic.hdw.DeviceId;
import ru.softlogic.hdw.Hardware;
import ru.softlogic.hdw.dev.printer.pos.BarcodeApi;
import ru.softlogic.hdw.dev.printer.pos.EscPosUtils;
import ru.softlogic.hdw.dev.printer.pos.ImageApi;
import ru.softlogic.hdw.dev.printer.pos.InfoApi;
import ru.softlogic.hdw.dev.printer.pos.LoadFontApi;
import ru.softlogic.hdw.dev.printer.pos.PosPrinterApi;
import ru.softlogic.hdw.dev.printer.pos.PosPrtOptions;
import ru.softlogic.hdw.dev.printer.pos.SecurityApi;
import ru.softlogic.hdw.dev.printer.pos.StatisticApi;
import ru.softlogic.hdw.dev.printer.pos.WrongImageException;
import ru.softlogic.hdw.dev.printer.pos.fonts.FontProcessor;
import ru.softlogic.io.BidirectionPort;
import ru.softlogic.io.Port;

public abstract class BaseApi
implements PosPrinterApi,
ImageApi {
    private final BidirectionPort port;
    private final PosPrtOptions options;
    private final Logger log;
    private final Cmd cmd;
    private final String type;

    public BaseApi(BidirectionPort port, PosPrtOptions options, String type, Logger log) {
        if (port == null) {
            throw new NullPointerException("BidirectionPort is null");
        }
        if (options == null) {
            throw new NullPointerException("PosPrtOptions is null");
        }
        this.port = port;
        this.options = options;
        this.log = log;
        this.type = type;
        port.setTimeout(2000);
        this.cmd = new Cmd(type, log);
        this.cmd.setAlias('w', options.getWidth() * 8);
        this.cmd.setAlias('l', options.getLeftMargin() * 8);
    }

    public void open() throws IOException {
        this.port.open();
    }

    public void close() {
        this.port.close();
    }

    public void init() throws IOException {
        this.log.info((Object)("Lm=" + this.options.getLeftMargin() * 8 + ", wd=" + this.options.getWidth() * 8));
        this.send("clear");
        this.sendParam("width", this.options.getWidth() * 8);
        this.sendParam("left", this.options.getLeftMargin() * 8);
        this.send("span", this.options.getSpacing());
        this.send("font", this.options.getFont());
        this.send("encoding", 0);
        byte[] addInit = Hardware.getBytesParam((DeviceId)new DeviceId(0, this.type, 0), (String)"init");
        if (addInit != null) {
            this.port.write(addInit);
        }
    }

    public void reset() throws IOException {
        this.send("reset");
    }

    public void print(String text) throws IOException {
        this.log.info((Object)("Text encode: " + this.options.getEncode()));
        byte[] data = this.processTags(FontProcessor.process((PosPrinterApi)this, (PosPrtOptions)this.options, (String)this.type, (String)text)).getBytes(this.options.getEncode());
        this.port.write(data);
    }

    public void scroll(int scroll) throws IOException {
        this.sendParam("scroll", scroll);
    }

    public void cut(int type) throws IOException {
        this.send("cut", type);
    }

    public void eject(int steps) throws IOException {
        this.sendParam("eject", steps);
    }

    public InfoApi getInfoApi() {
        return null;
    }

    public ImageApi getImageApi() {
        return null;
    }

    public StatisticApi getStatisticApi() {
        return null;
    }

    public LoadFontApi getLoadFontApi() {
        return null;
    }

    public BarcodeApi getBarcodeApi() {
        return null;
    }

    protected void send(String command) throws IOException {
        this.port.write(this.cmd.getCmd(command));
    }

    protected void send(String command, int type) throws IOException {
        this.port.write(this.cmd.getCmd(command, type));
    }

    protected void sendParam(String command, int param) throws IOException {
        this.port.write(this.cmd.getParamCmd(command, param));
    }

    protected String processTags(String text) {
        Map<String, byte[]> tags = this.cmd.getTags();
        for (Map.Entry<String, byte[]> e : tags.entrySet()) {
            String data = null;
            byte[] tv = e.getValue();
            if (tv != null) {
                try {
                    data = new String(tv, this.options.getEncode());
                }
                catch (IOException ex) {
                    this.log.error((Object)"Error on process string", (Throwable)ex);
                }
            }
            text = text.replace(e.getKey(), data == null ? "" : data);
        }
        return text;
    }

    public void loadImage(File path) throws IOException, WrongImageException, InterruptedException {
        if (path == null) {
            throw new NullPointerException("File is null");
        }
        if (!path.canRead()) {
            throw new FileNotFoundException("Image file is not found: " + path.getAbsolutePath());
        }
        this._loadImage(path);
    }

    public void printImage(File path, int size) throws IOException, WrongImageException, InterruptedException {
        this._printImage(path, size);
    }

    protected void _loadImage(File path) throws WrongImageException, IOException, InterruptedException {
        EscPosUtils.loadImage((Port)this.port, (File)path, (Logger)this.log);
    }

    protected void _printImage(File path, int size) throws IOException, WrongImageException, InterruptedException {
        EscPosUtils.printImageAlg2((Port)this.port, (File)path, (int)size, (Logger)this.log);
    }

    public String getPortAsStr() {
        return this.port.asStr();
    }

    public SecurityApi getSecurityApi() {
        return null;
    }
}

