/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.pos;

import java.io.IOException;
import ru.softlogic.hardware.pos.StatisticExtractor;
import ru.softlogic.io.BidirectionPort;

public class CustomBdStatisticExtractor
implements StatisticExtractor {
    private final BidirectionPort port;

    public CustomBdStatisticExtractor(BidirectionPort port) {
        if (port == null) {
            throw new NullPointerException("BidirectionPort is null");
        }
        this.port = port;
        port.setTimeout(1000);
    }

    @Override
    public String getPrintedLength() throws IOException {
        return new String(this.readPort(29, -29));
    }

    @Override
    public String getCutsNumber() throws IOException {
        return new String(this.readPort(29, -30));
    }

    @Override
    public String getRetrackingNumber() throws IOException {
        return new String(this.readPort(29, -28));
    }

    @Override
    public String getPowerUpNumber() throws IOException {
        return new String(this.readPort(29, -27));
    }

    private byte[] readPort(byte ... answer) throws IOException {
        this.port.write(answer);
        byte[] data = this.port.tryRead(12);
        if (data == null) {
            return "-".getBytes();
        }
        return data;
    }
}

