/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.pos;

import java.io.IOException;
import ru.softlogic.hardware.pos.InfoExtractor;
import ru.softlogic.io.BidirectionPort;
import ru.softlogic.io.utils.BU;

public class CustomBdInfoExtractor
implements InfoExtractor {
    private final BidirectionPort port;

    public CustomBdInfoExtractor(BidirectionPort port) {
        this.port = port;
    }

    @Override
    public int getModelId() throws IOException {
        this.port.write(new byte[]{29, 73, 1});
        int oneByte = this.port.readByte();
        if (oneByte == 93) {
            this.port.write(new byte[]{29, 73, 5});
            byte[] sx = this.port.tryRead(2);
            if (sx != null && sx.length == 2 && sx[0] == 2 && sx[1] == 25) {
                return 537;
            }
        }
        if ((oneByte & 0xFF) != 255) {
            return oneByte;
        }
        this.port.write(new byte[]{29, 73, -1});
        byte[] bytes = this.port.read(2);
        return bytes[0] << 8 | BU.c((byte)bytes[1]);
    }

    @Override
    public String getModel() throws IOException {
        int id = this.getModelId();
        switch (id) {
            case 93: {
                return "VKP80";
            }
            case 149: {
                return "VKP80II-EE";
            }
            case 517: {
                return "VKP80II";
            }
            case 537: {
                return "VKP80II-SX";
            }
            case 147: {
                return "TG2480";
            }
            case 168: {
                return "TG2480H";
            }
            case 167: {
                return "TG2460";
            }
            case 172: {
                return "TL80";
            }
            case 173: {
                return "TL60";
            }
        }
        return "UNK " + BU.toHex((int)id);
    }

    @Override
    public String getFirmware() throws IOException {
        this.port.write(new byte[]{29, 73, 3});
        return new String(this.port.read(4));
    }
}

